sass-spec
=========

Contains a test suite, helper script, and testing script. By their powers combined, you should be able to test sass files.

test suite
==========

The test suite is a direct copy of the spec directory of the hcatlin/sassc (with all the incorrect/outdated tests). The libsass folder in there is a port of the src/tests folder of the moovweb/libsass repo. They were ported over using the helper script in this repo.

helper script
=============

This script will take a source directory and a destination directory. It will search under the source directory for .scss files and move them (retaining the same hierarchy as in source) into the destination. It will automatically make folders as necessary (thanks 'mkdir -p'!), so just make sure the script has sufficient permissions or it will halt halfway.  It will place each .scss file into it own folder for testing as the testing script needs.  In addition, it will add an expected_output.css file into the test's directory for the testing script.  This output is generated by running sass on the test file. If this doesn't suit your needs, it should be fairly straightforward to modify the script to populate it another way.

testing script
==============

This script will take a folder and search under it for input.scss files. There should be an accompanying expected_output.css file. If you manually make the test suite hierarchy for your own tests, make sure to put every input file in its own folder with the accompanying expected_output.css file. For every found input.scss file with accompanying expected_output.css file, it will run either sass or sassc (to test libsass, you can easily change what it runs if you want to test, for example, nose-sass) depending on an option. It will compare the output to the expected_output.css file and report back on whether or not the test was successful. Once all tests are done, a blurb describing the results of the tests and a log of all failures will be displayed.
