
#
# generated by genmod v1.0
#
# style cacm
#

$record_number = 0;

sub conv_cacm {
  local(%can) = @_;
  $record_number++;

  if (!defined $can{'CiteType'}) {
    &bib'gotwarn("required field CiteType is not defined");
    $can{'CiteType'} = 'article';
  }
  local($date) = undef;
  if (defined $can{'Month'}) {
    local($mo) = &bp_util'output_month($can{'Month'}, 'short');
    if (defined $can{'Year'}) {
      $date = "$mo $can{'Year'}";
    } else {
      $date = $mo;
    }
  } else {
    $date = $can{'Year'} if defined $can{'Year'};
  }

  local($edname) = '';
  if (defined $can{'Editors'}) {
    $edname = $can{'Editors'};
    if ($can{'Editors'} =~ /$bib'cs_sep/) {
      $edname = 'Eds.';
    } else {
      $edname = 'Ed.';
    }
  }

  local($pp, $wp) = (undef,undef);
  $pp = $can{'Pages'}      if defined $can{'Pages'};
  $wp = $can{'PagesWhole'} if defined $can{'PagesWhole'};
  if ( (!defined $wp) && (defined $pp) && ($pp !~ /-|,/) ) {
    $wp = $pp;
    $pp = undef;
  }
  # set default type using the CiteType field
  $type = &cacm_default_type($can{'CiteType'});

  # Initialize output string
  $str = '';
  $str .= "m1100";


  if      ($type eq 'book') {
    if (defined $can{'Authors'}) {
      local($tAuthors);
      $tAuthors = &bp_util'canon_to_name($can{'Authors'}, 'reverse');
      $str .= "$tAuthors ";
    }
    if (defined $can{'Editors'}) {
      local($tEditors);
      $tEditors = &bp_util'canon_to_name($can{'Editors'}, 'reverse');
      $str .= "$tEditors, ${edname} ";
    }
    if (defined $can{'Title'}) {
      $str .= "m0102$can{'Title'}m0112. ";
    }
    $str .= "$can{'Publisher'}, "        if defined $can{'Publisher'};
    $str .= "$can{'PubAddress'}, "       if defined $can{'PubAddress'};
    $str .= "${date}."                   if defined ${date};
  } elsif ($type eq 'article') {
    if (defined $can{'Authors'}) {
      local($tAuthors);
      $tAuthors = &bp_util'canon_to_name($can{'Authors'}, 'reverse');
      $str .= "$tAuthors ";
    }
    $str .= "$can{'Title'}. "            if defined $can{'Title'};
    if (defined $can{'Journal'}) {
      $str .= "m0102$can{'Journal'}m0112 ";
      if (defined $can{'Volume'}) {
        $str .= "m0102$can{'Volume'}m0112,";
      }
      $str .= "$can{'Number'}"           if defined $can{'Number'};
      $str .= " ";
    }
    $str .= "(${date}), "                if defined ${date};
    $str .= "${pp}."                     if defined ${pp};
  } elsif ($type eq 'inproceedings') {
    if (!defined $can{'SuperTitle'}) {
      &bib'gotwarn("No SuperTitle field in $type citation");
    }
    if (defined $can{'Authors'}) {
      local($tAuthors);
      $tAuthors = &bp_util'canon_to_name($can{'Authors'}, 'reverse');
      $str .= "$tAuthors ";
    }
    $str .= "$can{'Title'}. "            if defined $can{'Title'};
    if (defined $can{'SuperTitle'}) {
      $str .= "in m0102$can{'SuperTitle'}m0112, ";
    }
    if (defined $can{'Location'}) {
      $str .= "($can{'Location'}. $can{'Month'}). ";
    }
    $str .= "$can{'Organization'}/"      if defined $can{'Organization'};
    $str .= "$can{'Journal'}, "          if defined $can{'Journal'};
    $str .= "$can{'PubAddress'}, "       if defined $can{'PubAddress'};
    $str .= "$can{'Year'}, "             if defined $can{'Year'};
    $str .= "pp. ${pp}."                 if defined ${pp};
  } 
  $str =~ s/,\s+$/./;

  $str .= "\n";

  $str;
}

sub cacm_default_type {
  local($citetype) = @_;
  local($type) = 'article';

  if (defined $citetype) {
    if ($citetype =~ /^(book|article|inproceedings)$/) {
      $type = $citetype;
    } else {
      &bib'gotwarn("Type '$can{'CiteType'}' not recognized -- using default type 'article'");
    }
  }
  $type;
}

1;
