/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import ucar.unidata.util.Format;

public class GaussianLatitudes {
    private static final double XLIM = 1.0E-7;
    public double[] cosc;
    public double[] colat;
    public double[] gaussw;
    public double[] latd;
    public double[] sinc;
    public double[] wos2;

    public GaussianLatitudes(int nlat) {
        int i;
        int i2;
        int nzero = nlat / 2;
        this.cosc = new double[nlat];
        this.colat = new double[nlat];
        this.gaussw = new double[nlat];
        this.latd = new double[nlat];
        this.sinc = new double[nlat];
        this.wos2 = new double[nlat];
        for (int i3 = 0; i3 < nzero; ++i3) {
            this.cosc[i3] = Math.sin(((double)i3 + 0.5) * Math.PI / (double)nlat + 1.5707963267948966);
        }
        double FI = nlat;
        double FI1 = (double)nlat + 1.0;
        double A = FI * FI1 / Math.sqrt(4.0 * FI1 * FI1 - 1.0);
        double B = FI * FI1 / Math.sqrt(4.0 * FI * FI - 1.0);
        for (i2 = 0; i2 < nzero; ++i2) {
            double delta;
            int countIterations = 0;
            do {
                double G = this.lgord(this.cosc[i2], nlat);
                double GM = this.lgord(this.cosc[i2], nlat - 1);
                double GP = this.lgord(this.cosc[i2], nlat + 1);
                double GT = (this.cosc[i2] * this.cosc[i2] - 1.0) / (A * GP - B * GM);
                delta = G * GT;
                int n = i2;
                this.cosc[n] = this.cosc[n] - delta;
                ++countIterations;
            } while (!(Math.abs(delta) <= 1.0E-7));
            double C = 2.0 * (1.0 - this.cosc[i2] * this.cosc[i2]);
            double D = this.lgord(this.cosc[i2], nlat - 1);
            D = D * D * FI * FI;
            this.gaussw[i2] = C * (FI - 0.5) / D;
        }
        for (i2 = 0; i2 < nzero; ++i2) {
            this.colat[i2] = Math.acos(this.cosc[i2]);
            this.sinc[i2] = Math.sin(this.colat[i2]);
            this.wos2[i2] = this.gaussw[i2] / (this.sinc[i2] * this.sinc[i2]);
        }
        int next = nzero;
        if (nlat % 2 != 0) {
            this.cosc[next] = 0.0;
            double C = 2.0;
            double D = this.lgord(this.cosc[next], nlat - 1);
            D = D * D * FI * FI;
            this.gaussw[next] = C * (FI - 0.5) / D;
            this.colat[next] = 1.5707963267948966;
            this.sinc[next] = 1.0;
            this.wos2[next] = this.gaussw[next];
            ++next;
        }
        for (i = next; i < nlat; ++i) {
            this.cosc[i] = -this.cosc[nlat - i - 1];
            this.gaussw[i] = this.gaussw[nlat - i - 1];
            this.colat[i] = Math.PI - this.colat[nlat - i - 1];
            this.sinc[i] = this.sinc[nlat - i - 1];
            this.wos2[i] = this.wos2[nlat - i - 1];
        }
        for (i = 0; i < nlat; ++i) {
            this.latd[i] = Math.toDegrees(1.5707963267948966 - this.colat[i]);
        }
    }

    private double lgord(double cosc, int nlat) {
        double colat = Math.acos(cosc);
        double c = Math.sqrt(2.0);
        for (int k = 1; k <= nlat; ++k) {
            c *= Math.sqrt(1.0 - 1.0 / (double)(4 * k * k));
        }
        double FN = nlat;
        double ANG = FN * colat;
        double S1 = 0.0;
        double C4 = 1.0;
        double A = -1.0;
        double B = 0.0;
        for (int k = 0; k <= nlat; k += 2) {
            if (k == nlat) {
                C4 = 0.5 * C4;
            }
            S1 += C4 * Math.cos(ANG);
            double FK = k;
            ANG = colat * (FN - FK - 2.0);
            C4 = (A += 2.0) * (FN - (B += 1.0) + 1.0) / (B * (FN + FN - A)) * C4;
        }
        return S1 * c;
    }

    public static void main(String[] args) {
        int nlats = 512;
        GaussianLatitudes glat = new GaussianLatitudes(nlats);
        for (int i = 0; i < nlats - 1; ++i) {
            System.out.print(" lat " + i + " = " + Format.dfrac(glat.latd[i], 4));
            System.out.print(" diff " + i + " = " + (glat.latd[i + 1] - glat.latd[i]));
            System.out.println(" weight= " + Format.dfrac(glat.gaussw[i], 6));
        }
    }
}

