# Generated by default/object.tt
package Paws::AuditManager::AssessmentControlSet;
  use Moose;
  has Controls => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::AssessmentControl]', request_name => 'controls', traits => ['NameInRequest']);
  has Delegations => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::Delegation]', request_name => 'delegations', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has ManualEvidenceCount => (is => 'ro', isa => 'Int', request_name => 'manualEvidenceCount', traits => ['NameInRequest']);
  has Roles => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::Role]', request_name => 'roles', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has SystemEvidenceCount => (is => 'ro', isa => 'Int', request_name => 'systemEvidenceCount', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::AssessmentControlSet

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::AssessmentControlSet object:

  $service_obj->Method(Att1 => { Controls => $value, ..., SystemEvidenceCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::AssessmentControlSet object:

  $result = $service_obj->Method(...);
  $result->Att1->Controls

=head1 DESCRIPTION

Represents a set of controls in an AWS Audit Manager assessment.

=head1 ATTRIBUTES


=head2 Controls => ArrayRef[L<Paws::AuditManager::AssessmentControl>]

The list of controls contained with the control set.


=head2 Delegations => ArrayRef[L<Paws::AuditManager::Delegation>]

The delegations associated with the control set.


=head2 Description => Str

The description for the control set.


=head2 Id => Str

The identifier of the control set in the assessment. This is the
control set name in a plain string format.


=head2 ManualEvidenceCount => Int

The total number of evidence objects uploaded manually to the control
set.


=head2 Roles => ArrayRef[L<Paws::AuditManager::Role>]

The roles associated with the control set.


=head2 Status => Str

Specifies the current status of the control set.


=head2 SystemEvidenceCount => Int

The total number of evidence objects retrieved automatically for the
control set.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

