#!/usr/bin/perl

package eBay::API::XML::DataType::SellerDashboardAlertType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SellerDashboardAlertType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SellerDashboardAlertType

=head1 DESCRIPTION

A message to help the you understand your status as a seller (PowerSeller status, 
policy compliance status, etc.).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SellerDashboardAlertType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::SellerDashboardAlertSeverityCodeType;


my @gaProperties = ( [ 'Severity', 'ns:SellerDashboardAlertSeverityCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SellerDashboardAlertSeverityCodeType', '' ]
	, [ 'Text', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setSeverity()

Helps you understand whether the alert is identifying a problem
or is informational.

#    Argument: 'ns:SellerDashboardAlertSeverityCodeType'

=cut

sub setSeverity {
  my $self = shift;
  $self->{'Severity'} = shift
}

=head2 getSeverity()

  Calls: GetSellerDashboard
  Returned: Conditionally

#    Returns: 'ns:SellerDashboardAlertSeverityCodeType'

=cut

sub getSeverity {
  my $self = shift;
  return $self->{'Severity'};
}


=head2 setText()

The alert text. When you parse this text, you should assume that
some alerts may use plain text and some may include HTML.

#    Argument: 'xs:string'

=cut

sub setText {
  my $self = shift;
  $self->{'Text'} = shift
}

=head2 getText()

  Calls: GetSellerDashboard
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getText {
  my $self = shift;
  return $self->{'Text'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
