#!/usr/bin/perl

use Test::More;

BEGIN { use_ok( 'Net::Gmail::IMAP::Label::Proxy' ); }
require_ok( 'Net::Gmail::IMAP::Label::Proxy' );

my $data = {
'a0006 FETCH 1:301 (UID FLAGS INTERNALDATE RFC822.SIZE BODY.PEEK[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)])' =>
	'a0006 FETCH 1:301 (UID FLAGS INTERNALDATE RFC822.SIZE BODY.PEEK[HEADER.FIELDS (DATE FROM SUBJECT TO CC MESSAGE-ID REFERENCES CONTENT-TYPE CONTENT-DESCRIPTION IN-REPLY-TO REPLY-TO LINES LIST-POST X-LABEL)] X-GM-LABELS)',
'a0054 UID FETCH 39468 (BODY.PEEK[])' =>
	'a0054 UID FETCH 39468 (BODY.PEEK[] X-GM-LABELS)',
'a0054 UID FETCH 39468 BODY.PEEK[]' =>
	'a0054 UID FETCH 39468 (BODY.PEEK[] X-GM-LABELS)' =>
'a0054 INVALID COMMAND' => 'a0054 INVALID COMMAND',
};

while (($key, $value) = each %$data) {
	subtest 'get_label transform' => sub {
		is(Net::Gmail::IMAP::Label::Proxy::get_label($key), $value, 'correct fetch');
	};
}

done_testing;
