# Generated by default/object.tt
package Paws::SSMContacts::Stage;
  use Moose;
  has DurationInMinutes => (is => 'ro', isa => 'Int', required => 1);
  has Targets => (is => 'ro', isa => 'ArrayRef[Paws::SSMContacts::Target]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::Stage

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::Stage object:

  $service_obj->Method(Att1 => { DurationInMinutes => $value, ..., Targets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::Stage object:

  $result = $service_obj->Method(...);
  $result->Att1->DurationInMinutes

=head1 DESCRIPTION

A set amount of time that an escalation plan or engagement plan engages
the specified contacts or contact methods.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DurationInMinutes => Int

The time to wait until beginning the next stage.


=head2 B<REQUIRED> Targets => ArrayRef[L<Paws::SSMContacts::Target>]

The contacts or contact methods that the escalation plan or engagement
plan is engaging.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

