/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeNormalizer;
import edu.stanford.nlp.util.Filter;

public class ATBTreeUtils {
    private static final Filter<Tree> emptyFilter = new ArabicTreeNormalizer.ArabicEmptyFilter();
    private static final TreeFactory tf = new LabeledScoredTreeFactory();

    private ATBTreeUtils() {
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\(", "-LRB-");
        s = s.replaceAll("\\)", "-RRB-");
        s = s.replaceAll("\\+", "-PLUS-");
        return s;
    }

    public static String unEscape(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("-LRB-", "(");
        s = s.replaceAll("-RRB-", ")");
        s = s.replaceAll("-PLUS-", "+");
        return s;
    }

    public static String flattenTree(Tree t) {
        t = t.prune(emptyFilter, tf);
        String flatString = t.yield().toString();
        return flatString;
    }

    public static String taggedStringFromTree(Tree t, boolean removeEscaping) {
        t = t.prune(emptyFilter, tf);
        Sentence<TaggedWord> taggedSentence = t.taggedYield();
        for (TaggedWord token : taggedSentence) {
            token.setWord(removeEscaping ? ATBTreeUtils.unEscape(token.word()) : token.word());
        }
        return taggedSentence.toString(false);
    }

    public static void main(String[] args) {
        String debug = "( the big lion ) + (the small rabbit)";
        String escaped = ATBTreeUtils.escape(debug);
        System.out.println(escaped);
    }
}

