use strict;
use Test::More;

use parent 'Class::Accessor::Inherited::XS::Compat';
__PACKAGE__->mk_object_accessors(['foo', 'foo', 2]);
__PACKAGE__->mk_class_accessors(['bar', undef, 0, 0, 1]);
__PACKAGE__->mk_class_accessors(['baz', sub {{}}, 0, 0, 1]);
__PACKAGE__->mk_inherited_accessors(['foobar', 'foobar', 2]);

sub exception (&) {
    $@ = undef;
    eval { shift->() };
    $@
}

my $self = bless {};
like exception {$self->foo(12)}, qr/nonreference/;
is($self->foo, 12);

$self->foo({});
is($self->foo, undef);

{
    my $ref = {a => 42};
    $self->foo($ref);
    is($self->foo->{a}, 42);
}
is($self->foo, undef);

__PACKAGE__->bar({});
is(__PACKAGE__->bar, undef);

is(__PACKAGE__->baz, undef);
is(__PACKAGE__->baz, undef);

__PACKAGE__->baz({});
is(__PACKAGE__->baz, undef);

__PACKAGE__->foobar({});
is(__PACKAGE__->foobar, undef);

done_testing;
