# Generated by default/object.tt
package Paws::LexModelsV2::BotSummary;
  use Moose;
  has BotId => (is => 'ro', isa => 'Str', request_name => 'botId', traits => ['NameInRequest']);
  has BotName => (is => 'ro', isa => 'Str', request_name => 'botName', traits => ['NameInRequest']);
  has BotStatus => (is => 'ro', isa => 'Str', request_name => 'botStatus', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedDateTime', traits => ['NameInRequest']);
  has LatestBotVersion => (is => 'ro', isa => 'Str', request_name => 'latestBotVersion', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::BotSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::BotSummary object:

  $service_obj->Method(Att1 => { BotId => $value, ..., LatestBotVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::BotSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->BotId

=head1 DESCRIPTION

Summary information about a bot returned by the ListBots operation.

=head1 ATTRIBUTES


=head2 BotId => Str

The unique identifier assigned to the bot. Use this ID to get detailed
information about the bot with the DescribeBot operation.


=head2 BotName => Str

The name of the bot.


=head2 BotStatus => Str

The current status of the bot. When the status is C<Available> the bot
is ready for use.


=head2 Description => Str

The description of the bot.


=head2 LastUpdatedDateTime => Str

The date and time that the bot was last updated.


=head2 LatestBotVersion => Str

The latest numerical version in use for the bot.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

