# Generated by default/object.tt
package Paws::EMR::ManagedScalingPolicy;
  use Moose;
  has ComputeLimits => (is => 'ro', isa => 'Paws::EMR::ComputeLimits');

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMR::ManagedScalingPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMR::ManagedScalingPolicy object:

  $service_obj->Method(Att1 => { ComputeLimits => $value, ..., ComputeLimits => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMR::ManagedScalingPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->ComputeLimits

=head1 DESCRIPTION

Managed scaling policy for an Amazon EMR cluster. The policy specifies
the limits for resources that can be added or terminated from a
cluster. The policy only applies to the core and task nodes. The master
node cannot be scaled after initial configuration.

=head1 ATTRIBUTES


=head2 ComputeLimits => L<Paws::EMR::ComputeLimits>

The EC2 unit limits for a managed scaling policy. The managed scaling
activity of a cluster is not allowed to go above or below these limits.
The limit only applies to the core and task nodes. The master node
cannot be scaled after initial configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

