######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 9
package Geo::Location::TimeZone::I;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 127.5 to 142.5
	"9" => {
		# Grid 9:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"139" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[134.770263671875,-82.5],[127.507957458496,-82.5],[127.507957458496,-90],[127.5,-90],[127.5,-82.5],[127.5,-82.5],[134.770263671875,-82.5],],
			},
		},
		# Grid 9:-5 ; 1 records
		"-5" => {
			"140" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[134.770263671875,-67.5],[127.507957458496,-67.5],[127.507957458496,-82.5],[127.5,-82.5],[127.5,-67.5],[127.5,-67.5],[134.770263671875,-67.5],],
			},
		},
		# Grid 9:-4 ; 2 records
		"-4" => {
			"def_z" => "Antartica/DumontDUrville",
			"141" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[134.770263671875,-52.5],[127.507957458496,-52.5],[127.507957458496,-67.5],[127.5,-67.5],[127.5,-52.5],[127.5,-52.5],[134.770263671875,-52.5],],
			},
		},
		# Grid 9:-3 ; 3 records
		"-3" => {
			"def_z" => "Etc/GMT+10",
			"142" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[134.770263671875,-37.5],[127.507957458496,-37.5],[127.507957458496,-52.5],[127.5,-52.5],[127.5,-37.5],[127.5,-37.5],[134.770263671875,-37.5],],
			},
			"401" => {
				"z" => "Australia/Darwin",
				"c" => "ESRI",
				"s" => "24,1",
				"p" => [[132.450805664062,-37.5],[140.972211882964,-37.5],[140.968048095703,-38.0642166137695],[140.674987792969,-38.0686111450195],[140.404968261719,-37.9280548095703],[140.22802734375,-37.6594390869141],[140.114135742188,-37.5805587768555],[140.128295898438,-37.5361175537109],[140.063668638965,-37.5],[140.013061575806,-37.5],[140.002197265625,-37.5050048828125],[139.997619098087,-37.5],[134.296936035156,-37.5],[132.450805664062,-37.5],],
			},
		},
		# Grid 9:-2 ; 4 records
		"-2" => {
			"0" => {
				"z" => "Australia/Queensland",
				"c" => "GPL",
				"s" => "custom.9X-2.qld-sa-nt.border",
				"p" => [[142.5,-29],[141,-29],[141.000549316406,-25.9997215270996],[138.000518798828,-25.999454498291],[138.000428340047,-22.5],[142.5,-22.5],[142,5],],
			},
			"143" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[134.770263671875,-22.5],[129.004026161296,-22.5],[129.005889892578,-26.0049018859863],[129.000274658203,-31.6926116943359],[128.248291015625,-32.0108337402344],[128.003875732422,-32.0922241210938],[127.753883361816,-32.1286087036133],[127.507957458496,-32.2266616821289],[127.507957458496,-37.5],[127.5,-37.5],[127.5,-22.5],[127.5,-22.5],[134.770263671875,-22.5],],
			},
			"185" => {
				"z" => "Australia/Broken_Hill",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[141.665802001953,-22.5],[142.5,-22.5],[142.5,-37.5],[140.972211882964,-37.5],[140.997863769531,-34.0240249633789],[141.002655029297,-29.0002212524414],[141.000549316406,-25.9997215270996],[138.000518798828,-25.999454498291],[138.000428340047,-22.5],[139.454315185547,-22.5],[141.665802001953,-22.5],],
			},
			"402" => {
				"z1" => "138.6,-30.9333333,Australia/South",
				"z0" => "138.6,-34.9333333,Australia/Adelaide",
				"c" => "ESRI",
				"s" => "24,1",
				"p" => [[136.979400634766,-22.5],[138.000428340047,-22.5],[138.000518798828,-25.999454498291],[141.000549316406,-25.9997215270996],[141.002655029297,-29.0002212524414],[140.997863769531,-34.0240249633789],[140.972211882964,-37.5],[140.063668638965,-37.5],[140.040802001953,-37.4872207641602],[140.013061575806,-37.5],[139.997619098087,-37.5],[139.814422607422,-37.2997283935547],[139.737457275391,-37.1780548095703],[139.783599853516,-37.1536102294922],[139.7802734375,-37.107780456543],[139.741058349609,-37.0827789306641],[139.731353759766,-37.0097274780273],[139.669708251953,-36.9636154174805],[139.800262451172,-36.8947219848633],[139.854675292969,-36.8261108398438],[139.861633300781,-36.666389465332],[139.826904296875,-36.5777816772461],[139.573028564453,-36.0924987792969],[139.231353759766,-35.7636184692383],[138.800537109375,-35.5369491577148],[138.655548095703,-35.5605545043945],[138.535522460938,-35.6544418334961],[138.300888061523,-35.6543159484863],[138.20881652832,-35.7173194885254],[138.136932373047,-35.8550033569336],[138.038024902344,-35.9241714477539],[137.928863525391,-35.8766632080078],[137.749389648438,-35.8677749633789],[137.605529785156,-35.929443359375],[137.614135742188,-36.0147247314453],[137.457733154297,-36.0866622924805],[137.354400634766,-36.0019454956055],[137.221893310547,-35.9836120605469],[137.156646728516,-36.0436172485352],[137.016082763672,-36.0269470214844],[136.906097412109,-36.0602798461914],[136.846618652344,-36.0308303833008],[136.716369628906,-36.0716705322266],[136.667755126953,-35.9877777099609],[136.534423828125,-35.9124984741211],[136.572479248047,-35.7763404846191],[136.489471435547,-35.5719718933105],[136.475296020508,-35.2546920776367],[136.423889160156,-35.1802444458008],[135.954132080078,-35.0102844238281],[135.928039550781,-34.9594421386719],[135.786651611328,-34.8602828979492],[135.721343994141,-34.8686065673828],[135.677764892578,-34.9555587768555],[135.624114990234,-34.95361328125],[135.606079101562,-34.8930587768555],[135.474670410156,-34.7511138916016],[135.322479248047,-34.6911087036133],[135.348846435547,-34.6530532836914],[135.321899414062,-34.6216659545898],[135.218841552734,-34.5641632080078],[135.105621337891,-34.593017578125],[135.056243896484,-34.449821472168],[134.695571899414,-33.9521942138672],[134.444473266602,-33.7832717895508],[134.453598022461,-33.4363021850586],[134.337478637695,-33.2040367126465],[134.269134521484,-33.1597213745117],[134.235504150391,-33.0513916015625],[134.147766113281,-33.0274963378906],[134.203857421875,-33.011116027832],[134.194702148438,-32.9522247314453],[134.061096191406,-32.92138671875],[134.12939453125,-32.8427734375],[134.068298339844,-32.7166595458984],[134.217742919922,-32.7283325195312],[134.194122314453,-32.790283203125],[134.214416503906,-32.8130569458008],[134.22412109375,-32.7838897705078],[134.296936035156,-32.6802825927734],[134.282196044922,-32.5999984741211],[134.143035888672,-32.4575042724609],[134.035522460938,-32.4638900756836],[133.993835449219,-32.5061111450195],[133.931365966797,-32.5008392333984],[133.905548095703,-32.5450057983398],[133.850524902344,-32.5405578613281],[133.776290893555,-32.4315910339355],[133.538223266602,-32.3233757019043],[133.417205810547,-32.2133331298828],[133.304138183594,-32.1969451904297],[133.267211914062,-32.220832824707],[133.185516357422,-32.1866607666016],[133.144714355469,-32.2058334350586],[133.059143066406,-32.1147232055664],[132.977447509766,-32.1130599975586],[132.835510253906,-31.9797210693359],[132.764434814453,-31.9508323669434],[132.549133300781,-31.9388885498047],[132.450805664062,-31.9727745056152],[132.479400634766,-32.0325012207031],[132.414154052734,-32.0116729736328],[132.203857421875,-32.0316696166992],[132.090789794922,-31.9211120605469],[131.769134521484,-31.7222213745117],[131.152191162109,-31.4741668701172],[130.838012695312,-31.6058349609375],[130.148864746094,-31.5791664123535],[129.000274658203,-31.6926116943359],[129.005889892578,-26.0049018859863],[129.004026161296,-22.5],[129.99983215332,-22.5],[136.979400634766,-22.5],],
			},
		},
		# Grid 9:-1 ; 3 records
		"-1" => {
			"def_z1" => "130.833,-12.466,Australia/Darwin",
			"def_z0" => "130.833,-21.0,Australia/North",
			"144" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[134.770263671875,-7.5],[127.5,-7.5],[127.5,-14.0630142336284],[127.504440307617,-14.0633344650269],[127.61360168457,-14.1361122131348],[127.760536193848,-14.3005561828613],[127.822769165039,-14.3869457244873],[127.82470703125,-14.4444446563721],[127.864990234375,-14.4205551147461],[127.851379394531,-14.4822216033936],[127.885536193848,-14.4727764129639],[127.949417114258,-14.5266666412354],[127.945251464844,-14.5763893127441],[128.003601074219,-14.5611114501953],[128.069702148438,-14.6458339691162],[128.21533203125,-14.6997423171997],[128.32585144043,-14.7101612091064],[128.387680053711,-14.7971878051758],[128.541656494141,-14.7577781677246],[128.999969482422,-14.8710775375366],[129.004026161296,-22.5],[127.5,-22.5],[127.5,-7.5],[127.5,-7.5],[134.770263671875,-7.5],],
			},
			"186" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[141.621337890625,-22.5],[138.000428340047,-22.5],[138.000274658203,-16.5547218322754],[138.190246582031,-16.7049980163574],[138.303863525391,-16.7511138916016],[138.486907958984,-16.7877807617188],[138.646636962891,-16.7797241210938],[138.848571777344,-16.8777770996094],[138.989364624023,-16.8906097412109],[139.119171142578,-16.7877826690674],[139.156234741211,-16.589599609375],[139.306076049805,-16.4542541503906],[139.454315185547,-16.4381408691406],[139.557434082031,-16.3898029327393],[139.737899780273,-16.4413642883301],[139.744338989258,-16.502592086792],[139.557434082031,-16.676607131958],[139.473648071289,-16.8361206054688],[139.50749206543,-16.9891891479492],[139.563873291016,-17.0294704437256],[139.581604003906,-17.0987548828125],[139.483322143555,-17.188985824585],[139.454315185547,-17.2711582183838],[139.471664428711,-17.4041194915771],[139.621887207031,-17.5255584716797],[139.809143066406,-17.5722236633301],[139.930816650391,-17.6313896179199],[139.981903076172,-17.7002754211426],[140.051361083984,-17.7180557250977],[140.396636962891,-17.6733322143555],[140.736083984375,-17.5200004577637],[140.758026123047,-17.4777755737305],[140.835235595703,-17.4502754211426],[140.87744140625,-17.3783340454102],[140.949127197266,-17.013614654541],[141.051086425781,-16.8838882446289],[141.076354980469,-16.8033332824707],[141.129943847656,-16.780834197998],[141.2119140625,-16.6725006103516],[141.326904296875,-16.3319435119629],[141.348571777344,-16.219165802002],[141.426910400391,-16.0791664123535],[141.375793457031,-15.9294452667236],[141.460510253906,-15.536111831665],[141.665802001953,-15.036111831665],[141.567749023438,-14.7688903808594],[141.520263671875,-14.4750003814697],[141.591644287109,-14.2647228240967],[141.599975585938,-14.1344451904297],[141.466064453125,-13.9066677093506],[141.526916503906,-13.5741672515869],[141.629669189453,-13.3541660308838],[141.667755126953,-13.3477783203125],[141.688293457031,-13.2608337402344],[141.583862304688,-12.9891662597656],[141.629943847656,-12.8952789306641],[141.652191162109,-12.9125003814697],[141.759704589844,-12.8080558776855],[141.805541992188,-12.6719455718994],[141.815795898438,-12.7036113739014],[141.868560791016,-12.7008323669434],[141.890533447266,-12.8463878631592],[141.934967041016,-12.911111831665],[141.908020019531,-12.7502784729004],[142.004974365234,-12.7216663360596],[141.917205810547,-12.7180557250977],[141.829681396484,-12.6627788543701],[141.88916015625,-12.6091651916504],[141.975250244141,-12.5894432067871],[141.925537109375,-12.5611114501953],[141.819122314453,-12.59694480896],[141.772216796875,-12.5736103057861],[141.758880615234,-12.5322227478027],[141.694122314453,-12.5044460296631],[141.744415283203,-12.4611110687256],[141.661376953125,-12.4483337402344],[141.654418945312,-12.5283336639404],[141.695251464844,-12.5480556488037],[141.593017578125,-12.5575008392334],[141.665802001953,-12.3866672515869],[141.668853759766,-12.3819427490234],[141.716064453125,-12.2330551147461],[141.805816650391,-12.2374992370605],[141.750274658203,-12.2049999237061],[141.852447509766,-11.9844436645508],[141.909973144531,-11.9594440460205],[141.890533447266,-11.9883327484131],[141.91748046875,-12.1052780151367],[141.964416503906,-12.0408344268799],[142.028869628906,-12.0622215270996],[141.942199707031,-11.9547214508057],[142.124114990234,-11.3672218322754],[142.158874511719,-11.1494445800781],[142.141937255859,-10.9566669464111],[141.007019042969,-9.12846755981445],[141.00588357266,-7.5],[142.5,-7.5],[142.5,-22.5],[141.621337890625,-22.5],],
			},
		},
		# Grid 9:0 ; 4 records
		"0" => {
			"def_z" => "Asia/Jayapura",
			"145" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[134.770263671875,7.5],[127.507949829102,7.5],[127.507949829102,3.43973851203918],[127.5,3.42822644705649],[127.5,-7.5],[127.5,7.5],[127.5,7.5],[134.770263671875,7.5],],
			},
			"187" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,3",
				"p" => [[141.665802001953,-7.5],[141.00588357266,-7.5],[141.002471923828,-2.60708522796631],[141,0],[142.5,-0.0020661664822671],[142.5,-7.5],[139.454315185547,-7.5],[141.665802001953,-7.5],],
			},
			"268" => {
				"z" => "Etc/GMT+11",
				"c" => "ESRI",
				"s" => "17,2",
				"p" => [[142.5,-7.5],[142.5,-0.0020661664822671],[141,0],[137,1.20000004768372],[137,7.5],[142.5,7.5],[142.5,-7.5],],
			},
		},
		# Grid 9:1 ; 3 records
		"1" => {
			"def_z" => "Pacific/Yap",
			"146" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[134.770263671875,22.5],[127.507949829102,22.5],[127.507949829102,7.5],[127.5,7.5],[127.5,22.5],[127.5,22.5],[134.770263671875,22.5],],
			},
			"178" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,2",
				"p" => [[142.5,12],[142.5,19.2308883666992],[135.512237548828,19.2308883666992],[135.512232232225,22.5],[142.5,22.5],[142.5,12],],
			},
		},
		# Grid 9:2 ; 3 records
		"2" => {
			"def_z" => "Asia/Tokyo",
			"147" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[134.770263671875,37.5],[127.5,37.5],[127.5,32.9641342163086],[127.507949829102,32.9641342163086],[127.507949829102,27.5251979827881],[127.5,27.5251979827881],[127.5,23.5489378946289],[127.507949829102,23.5489082336426],[127.507949829102,22.5],[127.5,22.5],[127.5,37.5],[127.5,37.5],[134.770263671875,37.5],],
			},
			"179" => {
				"z" => "Etc/GMT+10",
				"c" => "ESRI",
				"s" => "13,2",
				"p" => [[135.512232232225,22.5],[135.512222290039,28.6133232116699],[142.5,28.6482627104833],[142.5,22.5],[135.512232232225,22.5],],
			},
		},
		# Grid 9:3 ; 3 records
		"3" => {
			"def_z" => "Asia/Vladivostok",
			"148" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[127.5,51.2391586303711],[127.5,50.2436608625249],[127.586067199707,50.2085647583008],[127.569717407227,50.1283264160156],[127.5,50.05458408631],[127.5,49.9634754188917],[127.531372070312,49.9197158813477],[127.508331298828,49.8199920654297],[127.541931152344,49.7824935913086],[127.671653747559,49.7488784790039],[127.691360473633,49.6672134399414],[127.821380615234,49.5911026000977],[127.974426269531,49.6024932861328],[128.074981689453,49.5422210693359],[128.191070556641,49.5341644287109],[128.505249023438,49.5869369506836],[128.625946044922,49.5696716308594],[128.668853759766,49.6119384765625],[128.802459716797,49.5591583251953],[128.752471923828,49.4680480957031],[128.875244140625,49.4777679443359],[128.992706298828,49.4416580200195],[129.076873779297,49.3527908325195],[129.199676513672,49.3905944824219],[129.353546142578,49.3423004150391],[129.369079589844,49.4139633178711],[129.412170410156,49.4317626953125],[129.523468017578,49.3912353515625],[129.544952392578,49.2931823730469],[129.721862792969,49.2662658691406],[129.732696533203,49.1929321289062],[129.847442626953,49.1579513549805],[129.8330078125,49.1179504394531],[129.912719726562,49.0824127197266],[129.916351318359,49.0296401977539],[130.228851318359,48.8622131347656],[130.418029785156,48.8961029052734],[130.504425048828,48.851936340332],[130.627685546875,48.8746490478516],[130.674987792969,48.8441543579102],[130.523040771484,48.6027755737305],[130.617462158203,48.5619354248047],[130.626892089844,48.4772109985352],[130.757751464844,48.4880447387695],[130.737457275391,48.418327331543],[130.832183837891,48.2969436645508],[130.659423828125,48.0986022949219],[130.681365966797,48.0455474853516],[130.889709472656,47.9002685546875],[130.946075439453,47.8005447387695],[130.946350097656,47.7113800048828],[131.04052734375,47.6758270263672],[131.416656494141,47.7386016845703],[131.537200927734,47.718879699707],[131.575531005859,47.6560974121094],[131.678314208984,47.6991577148438],[131.91943359375,47.6699905395508],[132.341064453125,47.7424926757812],[132.54248046875,47.7138824462891],[132.659698486328,47.8658294677734],[132.671356201172,47.9497146606445],[132.808868408203,47.9419326782227],[132.884429931641,48.0086059570312],[133.018035888672,48.035270690918],[133.088562011719,48.1016616821289],[133.38720703125,48.1052703857422],[133.506652832031,48.0713806152344],[133.593566894531,48.172492980957],[133.696350097656,48.1869354248047],[133.751373291016,48.2497177124023],[133.97802734375,48.2597198486328],[134.045806884766,48.3252716064453],[134.415344238281,48.3911209106445],[134.482727050781,48.3502731323242],[134.571807861328,48.3644638061523],[134.610504150391,48.3069381713867],[134.740753173828,48.2671279907227],[134.681365966797,48.2205429077148],[134.667755126953,48.1072158813477],[134.583862304688,48.0627670288086],[134.557189941406,47.9947128295898],[134.598846435547,47.9047088623047],[134.661926269531,47.8741607666016],[134.684356689453,47.8009033203125],[134.770263671875,47.7394332885742],[134.767211914062,47.7074966430664],[134.68359375,47.6297149658203],[134.674133300781,47.5719375610352],[134.552093505859,47.4669189453125],[134.479125976562,47.4277725219727],[134.314697265625,47.4211044311523],[134.182464599609,47.3233261108398],[134.147766113281,47.2494354248047],[134.194702148438,47.206657409668],[134.222198486328,47.1108245849609],[134.131225585938,47.0742263793945],[134.062744140625,46.9752655029297],[134.066925048828,46.9160995483398],[134.011932373047,46.8238830566406],[134.043792724609,46.7528991699219],[133.997741699219,46.6401672363281],[133.901641845703,46.5722198486328],[133.845794677734,46.4755477905273],[133.849975585938,46.4399871826172],[133.928588867188,46.3924942016602],[133.861907958984,46.3313827514648],[133.910247802734,46.3144378662109],[133.883880615234,46.2936096191406],[133.900177001953,46.2503128051758],[133.686920166016,46.1433258056641],[133.724670410156,46.0652694702148],[133.660461425781,45.9345703125],[133.610778808594,45.9319381713867],[133.583038330078,45.8713760375977],[133.522216796875,45.8866577148438],[133.474670410156,45.8202743530273],[133.508026123047,45.7777709960938],[133.441925048828,45.6980438232422],[133.488555908203,45.6827697753906],[133.453308105469,45.647216796875],[133.468292236328,45.6222152709961],[133.419128417969,45.6072158813477],[133.417114257812,45.5690994262695],[133.190521240234,45.5041656494141],[133.149139404297,45.4508285522461],[133.092468261719,45.2441558837891],[133.122192382812,45.1286010742188],[133.033325195312,45.0616607666016],[132.923309326172,45.0219345092773],[131.988555908203,45.2419357299805],[131.864685058594,45.3455429077148],[131.753601074219,45.2130508422852],[131.646362304688,45.1988754272461],[131.644439697266,45.1055526733398],[131.466644287109,44.9672088623047],[131.349975585938,44.9747085571289],[131.212463378906,44.9105453491211],[131.118011474609,44.9258270263672],[131.04248046875,44.8633270263672],[130.953857421875,44.8460998535156],[131.095520019531,44.6913757324219],[131.298034667969,44.0519332885742],[131.247192382812,44.0274887084961],[131.231079101562,43.973876953125],[131.246063232422,43.9180526733398],[131.199127197266,43.8188858032227],[131.220520019531,43.5952682495117],[131.188873291016,43.5366592407227],[131.194427490234,43.5277709960938],[131.223022460938,43.5116653442383],[131.304412841797,43.4558258056641],[131.311370849609,43.392219543457],[131.274139404297,43.3633270263672],[131.261108398438,43.2644424438477],[131.191070556641,43.1966552734375],[131.214416503906,43.1330490112305],[131.104675292969,43.0361099243164],[131.132171630859,42.9191589355469],[131.045806884766,42.9019317626953],[131.015258789062,42.8549957275391],[130.818572998047,42.8760986328125],[130.770538330078,42.8319396972656],[130.638031005859,42.8316650390625],[130.405242919922,42.7180480957031],[130.458862304688,42.6799926757812],[130.538879394531,42.6819381713867],[130.605224609375,42.6197128295898],[130.618011474609,42.5794372558594],[130.559143066406,42.5066604614258],[130.604370117188,42.4218597412109],[130.567474365234,42.4430465698242],[130.514709472656,42.6022186279297],[130.461364746094,42.593879699707],[130.472473144531,42.5569381713867],[130.437194824219,42.5449981689453],[130.425537109375,42.6022186279297],[130.243286132812,42.7183227539062],[130.252197265625,42.8924942016602],[130.100799560547,42.9119338989258],[130.135803222656,42.9622116088867],[130.107452392578,42.9783248901367],[129.999603271484,42.9614181518555],[129.907531738281,43.0058212280273],[129.875579833984,42.9897079467773],[129.905578613281,42.9699783325195],[129.851226806641,42.9599838256836],[129.757751464844,42.7297134399414],[129.753326416016,42.6941528320312],[129.787475585938,42.6749954223633],[129.742736816406,42.6408309936523],[129.760803222656,42.6033248901367],[129.724975585938,42.5613784790039],[129.7119140625,42.4441528320312],[129.590789794922,42.4452667236328],[129.539703369141,42.3636093139648],[129.442199707031,42.4344329833984],[129.341918945312,42.4458236694336],[129.344116210938,42.4147109985352],[129.239959716797,42.3741607666016],[129.237731933594,42.3219375610352],[129.190521240234,42.3133239746094],[129.224395751953,42.29638671875],[129.175811767578,42.234992980957],[129.210235595703,42.2172088623047],[129.014099121094,42.0941925048828],[128.957733154297,42.0811080932617],[128.912200927734,42.0211029052734],[128.729125976562,42.0469436645508],[128.489410400391,41.9955444335938],[128.282470703125,42.0391616821289],[128.058868408203,42.0033264160156],[128.101898193359,41.7961044311523],[128.301910400391,41.5777740478516],[128.204406738281,41.4166641235352],[128.112731933594,41.3697128295898],[128.106079101562,41.394157409668],[128.044128417969,41.3894348144531],[128.047485351562,41.4188842773438],[128.020812988281,41.4085998535156],[128.000823974609,41.4455413818359],[127.981369018555,41.4227676391602],[127.873870849609,41.4394302368164],[127.858322143555,41.4044342041016],[127.647491455078,41.4027709960938],[127.55721282959,41.4297180175781],[127.53914642334,41.4636077880859],[127.5,41.4649034301789],[127.5,37.5],[127.5,52.5],[127.5,51.2391586303711],],
			},
			"260" => {
				"z" => "Etc/GMT+11",
				"c" => "ESRI",
				"s" => "17,1",
				"p" => [[142.5,43.3056602478027],[142.5,45.4947180824585],[140.947982788086,46.0306663513184],[141.552883645871,52.5],[142.5,52.5],[142.5,52.5],[142.5,43.3056602478027],],
			},
		},
		# Grid 9:4 ; 3 records
		"4" => {
			"def_z" => "Etc/GMT+10",
			"155" => {
				"z" => "Asia/Yakutsk",
				"c" => "ESRI",
				"s" => "12,1",
				"p" => [[127.5,56.9565505981445],[127.5,67.5],[132.180536996111,67.5],[132.870880126953,59.0671081542969],[132.858795166016,59.0220794677734],[132.926803588867,58.9715385437012],[132.904998779297,58.9213485717773],[132.62809753418,58.8806190490723],[132.558197021484,58.8002891540527],[132.568099975586,58.6309509277344],[132.539001464844,58.5808601379395],[132.404006958008,58.5066108703613],[132.243103027344,58.5144081115723],[132.191497802734,58.4728088378906],[132.263107299805,58.3073501586914],[132.092300415039,58.2122001647949],[132.154205322266,58.0681915283203],[131.731994628906,58.1865386962891],[131.564605712891,58.1935997009277],[131.544799804688,58.1701507568359],[131.54670715332,58.1407203674316],[131.656402587891,58.0772590637207],[131.687393188477,58.0065994262695],[131.82080078125,57.9630889892578],[131.870193481445,57.8332901000977],[132.147598266602,57.7234916687012],[132.083801269531,57.6379508972168],[131.864700317383,57.6070594787598],[131.687805175781,57.4502487182617],[131.660003662109,57.2782402038574],[131.549102783203,57.2559814453125],[131.279602050781,57.3628005981445],[131.269393920898,57.289379119873],[131.143295288086,57.211368560791],[131.178695678711,57.1767311096191],[131.333694458008,57.1661605834961],[131.516494750977,57.0938110351562],[131.878295898438,56.7685394287109],[131.775207519531,56.628719329834],[131.734603881836,56.4977493286133],[131.515396118164,56.5488700866699],[131.450103759766,56.4851188659668],[131.308197021484,56.4867286682129],[131.182006835938,56.4177589416504],[131.166397094727,56.2986297607422],[130.973999023438,55.9277992248535],[131.092407226562,55.7412986755371],[131.092193603516,55.6816596984863],[131.587493896484,55.7055015563965],[131.827697753906,55.6775398254395],[132.295806884766,55.7503890991211],[132.518707275391,55.7303810119629],[132.678298950195,55.6459693908691],[132.677795410156,55.5961112976074],[132.61979675293,55.5597991943359],[132.60319519043,55.5086402893066],[132.849899291992,55.4572105407715],[132.917205810547,55.4048690795898],[132.706207275391,55.3787994384766],[132.581207275391,55.2695693969727],[132.405197143555,55.2323989868164],[132.318206787109,55.107421875],[132.102005004883,55.0534400939941],[131.849700927734,54.863151550293],[131.639099121094,54.7886505126953],[131.438095092773,54.7626991271973],[131.268798828125,54.6486282348633],[131.24040222168,54.5149116516113],[131.1083984375,54.3609809875488],[131.043899536133,54.3248100280762],[130.788101196289,54.3088912963867],[130.595596313477,54.1670608520508],[130.440093994141,53.9528503417969],[130.445297241211,53.914421081543],[130.537094116211,53.8829689025879],[130.668395996094,53.8887901306152],[130.770401000977,53.8211212158203],[130.846801757812,53.8083114624023],[131.060302734375,53.8751602172852],[131.369003295898,53.7598609924316],[131.443298339844,53.5014495849609],[131.403305053711,53.2640800476074],[131.434204101562,53.244068145752],[131.738296508789,53.2888107299805],[131.833099365234,53.2546005249023],[131.836303710938,53.2038497924805],[131.960601806641,53.1641311645508],[132.076705932617,53.2617988586426],[132.149200439453,53.2800598144531],[132.796600341797,53.2339096069336],[132.939697265625,53.312068939209],[133.156692504883,53.3217506408691],[133.281600952148,53.5022888183594],[133.540496826172,53.5501403808594],[133.686492919922,53.4800109863281],[133.795303344727,53.5042381286621],[134.044998168945,53.4677696228027],[134.476501464844,53.6513710021973],[134.893905639648,53.4252281188965],[134.860794067383,53.3922309875488],[134.806304931641,53.3986701965332],[134.777206420898,53.3515586853027],[134.841598510742,53.3012886047363],[134.858093261719,53.2210998535156],[134.62939453125,52.9792289733887],[134.572006225586,52.8701705932617],[134.581802368164,52.7755508422852],[134.745300292969,52.6834907531738],[134.604995727539,52.582878112793],[134.594696044922,52.5398902893066],[134.640400131713,52.5],[133.882556091601,52.5],[133.407592773438,52.6711883544922],[133.248504638672,52.6645088195801],[133.174102783203,52.5619201660156],[133.216094970703,52.5287895202637],[133.207909018519,52.5],[127.5,52.5],[127.5,52.5],[127.5,56.9565505981445],],
			},
			"261" => {
				"z" => "Etc/GMT+11",
				"c" => "ESRI",
				"s" => "17,1",
				"p" => [[142.5,61.9474868774414],[142.5,52.5],[141.552883645871,52.5],[142.167449951172,59.0727043151855],[142.5,59.0929903703342],[142.5,61.9602605488188],[142.29280090332,61.9046401977539],[142.205093383789,61.9445304870605],[142.086395263672,62.0657501220703],[141.809005737305,62.0183601379395],[141.652297973633,62.0336494445801],[141.468994140625,62.214038848877],[141.377700805664,62.2585105895996],[141.22477722168,62.4492492675781],[142.5,67.3391298333185],[142.5,67.5],[142.5,60.5836029052734],[142.5,61.9474868774414],],
			},
		},
		# Grid 9:5 ; 3 records
		"5" => {
			"def_z" => "Etc/GMT+10",
			"121" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,1",
				"p" => [[127.52746822525,82.5],[127.531745910645,81.1609191894531],[127.5,81.1539243234133],[127.5,82.5],[127.52746822525,82.5],],
			},
			"262" => {
				"z" => "Etc/GMT+11",
				"c" => "ESRI",
				"s" => "17,1",
				"p" => [[142.5,68.3222503662109],[142.5,67.5],[142.5,74.0689216968656],[142.294448852539,74.1310653686523],[142.294448852539,74.5247344970703],[142.5,74.5398490585945],[142.5,82.5],[142.5,68.3222503662109],],
			},
		},
		# Grid 9:6 ; 1 records
		"6" => {
			"122" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,1",
				"p" => [[127.503509521484,90],[127.52746822525,82.5],[127.5,82.5],[127.5,90],[127.503509521484,90],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
