# DO NOT EDIT, PRETTY PLEASE!
# This file is automatically generated by wl-scanner.pl
#

use strict;
use warnings;
use utf8;

=encoding utf8
=cut

=head1 NAME

WL::xdg_shell - Perl binding for xdg_shell protocol

=head1 SYNOPSIS

  use WL::xdg_shell;

=head1 DESCRIPTION

B<WL::xdg_shell> is a package generated from Wayland protocol definition
using L<wl-scanner.pl>. It implements L<WL::Base> subclasses with wrappers
for requests, event processing and constants for enums.

It is not indended to be used directly. Instead, see L<WL::Connection> to see
how to obtain the object instances.

To see how to attach event callbacks and issue requests, please refer to
L<WL::Base> base class.

Until proper documentation is finished, please refer to documentation of C
bindings of the generated code (it is intended to be readable) to see what
arguments to give to requests and expect from events.

Please consider this an alpha quality code, whose API can change at any time,
until we reach version 1.0.

=cut

package WL::xdg_shell;

our $VERSION = 0.92;

package WL::xdg_shell;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'xdg_shell';

# Requests
use constant REQUEST_USE_UNSTABLE_VERSION => 0;
use constant REQUEST_GET_XDG_SURFACE => 1;
use constant REQUEST_GET_XDG_POPUP => 2;
use constant REQUEST_PONG => 3;

sub use_unstable_version
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_USE_UNSTABLE_VERSION, pack ('l',
		shift), $file);

	return $retval;
}

sub get_xdg_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_XDG_SURFACE, pack ('L L',
		($retval = new WL::xdg_surface ($self->{conn}))->{id},
		shift->{id}), $file);

	return $retval;
}

sub get_xdg_popup
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_XDG_POPUP, pack ('L L L L L l l L',
		($retval = new WL::xdg_popup ($self->{conn}))->{id},
		shift->{id},
		shift->{id},
		shift->{id},
		shift,
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub pong
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_PONG, pack ('L',
		shift), $file);

	return $retval;
}

# Events
use constant EVENT_PING => 0;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_PING) {
		@_ = unpack ('L', shift);
		return $self->ping (shift);
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant VERSION_CURRENT => 3;

package WL::xdg_surface;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'xdg_surface';

# Requests
use constant REQUEST_DESTROY => 0;
use constant REQUEST_SET_PARENT => 1;
use constant REQUEST_SET_MARGIN => 2;
use constant REQUEST_SET_TITLE => 3;
use constant REQUEST_SET_APP_ID => 4;
use constant REQUEST_SHOW_WINDOW_MENU => 5;
use constant REQUEST_MOVE => 6;
use constant REQUEST_RESIZE => 7;
use constant REQUEST_ACK_CONFIGURE => 8;
use constant REQUEST_SET_MAXIMIZED => 9;
use constant REQUEST_UNSET_MAXIMIZED => 10;
use constant REQUEST_SET_FULLSCREEN => 11;
use constant REQUEST_UNSET_FULLSCREEN => 12;
use constant REQUEST_SET_MINIMIZED => 13;

sub destroy
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESTROY, pack ('',
		), $file);

	return $retval;
}

sub set_parent
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_PARENT, pack ('L',
		shift->{id}), $file);

	return $retval;
}

sub set_margin
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_MARGIN, pack ('l l l l',
		shift,
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub set_title
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_TITLE, pack ('L/ax!4',
		shift."\x00"), $file);

	return $retval;
}

sub set_app_id
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_APP_ID, pack ('L/ax!4',
		shift."\x00"), $file);

	return $retval;
}

sub show_window_menu
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SHOW_WINDOW_MENU, pack ('L L l l',
		shift->{id},
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub move
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_MOVE, pack ('L L',
		shift->{id},
		shift), $file);

	return $retval;
}

sub resize
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_RESIZE, pack ('L L L',
		shift->{id},
		shift,
		shift), $file);

	return $retval;
}

sub ack_configure
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_ACK_CONFIGURE, pack ('L',
		shift), $file);

	return $retval;
}

sub set_maximized
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_MAXIMIZED, pack ('',
		), $file);

	return $retval;
}

sub unset_maximized
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_UNSET_MAXIMIZED, pack ('',
		), $file);

	return $retval;
}

sub set_fullscreen
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_FULLSCREEN, pack ('L',
		shift->{id}), $file);

	return $retval;
}

sub unset_fullscreen
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_UNSET_FULLSCREEN, pack ('',
		), $file);

	return $retval;
}

sub set_minimized
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_MINIMIZED, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_CONFIGURE => 0;
use constant EVENT_CLOSE => 1;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_CONFIGURE) {
		@_ = unpack ('l l L/ax!4 L', shift);
		return $self->configure (shift,
			shift,
			shift,
			shift);
	} elsif ($opcode == EVENT_CLOSE) {
		return $self->close ();
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant RESIZE_EDGE_NONE => 0;
use constant RESIZE_EDGE_TOP => 1;
use constant RESIZE_EDGE_BOTTOM => 2;
use constant RESIZE_EDGE_LEFT => 4;
use constant RESIZE_EDGE_TOP_LEFT => 5;
use constant RESIZE_EDGE_BOTTOM_LEFT => 6;
use constant RESIZE_EDGE_RIGHT => 8;
use constant RESIZE_EDGE_TOP_RIGHT => 9;
use constant RESIZE_EDGE_BOTTOM_RIGHT => 10;
use constant STATE_MAXIMIZED => 1;
use constant STATE_FULLSCREEN => 2;
use constant STATE_RESIZING => 3;
use constant STATE_ACTIVATED => 4;

package WL::xdg_popup;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'xdg_popup';

# Requests
use constant REQUEST_DESTROY => 0;

sub destroy
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESTROY, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_POPUP_DONE => 0;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_POPUP_DONE) {
		@_ = unpack ('L', shift);
		return $self->popup_done (shift);
	} else {
		die 'Bad opcode';
	}
}


=head1 BUGS

The interface documentation for the bindings is lacking.

Only client part implemented, not server.

=head1 SEE ALSO

=over

=item *

L<http://wayland.freedesktop.org/> -- Wayland project web site

=item *

L<wl-draw.pl> -- Example Wayland client

=item *

L<wl-scanner.pl> -- Tool that generated this module

=item *

L<WL::Base> -- Base class for Wayland objects

=item *

L<WL::Connection> -- Estabilish a Wayland connection

=back

=head1 COPYRIGHT

Copyright 2013, 2014 Lubomir Rintel

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

Copyright notice from the protocol definition file:

  Copyright © 2008-2013 Kristian Høgsberg
  Copyright © 2013      Rafael Antognolli
  Copyright © 2013      Jasper St. Pierre
  Copyright © 2010-2013 Intel Corporation
  
  Permission to use, copy, modify, distribute, and sell this
  software and its documentation for any purpose is hereby granted
  without fee, provided that the above copyright notice appear in
  all copies and that both that copyright notice and this permission
  notice appear in supporting documentation, and that the name of
  the copyright holders not be used in advertising or publicity
  pertaining to distribution of the software without specific,
  written prior permission.  The copyright holders make no
  representations about the suitability of this software for any
  purpose.  It is provided "as is" without express or implied
  warranty.
  
  THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
  SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
  THIS SOFTWARE.

=head1 AUTHORS

Lubomir Rintel C<lkundrak@v3.sk>

=cut

