/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public enum OS {
    UNKNOWN(null, false),
    WINDOWS("windows", false),
    MAC_OS("darwin", true),
    LINUX("linux", true);

    private final String libdir;
    public final boolean unix;

    private OS(String string2, boolean bl) {
        this.libdir = string2;
        this.unix = bl;
    }

    public static String uname() {
        try {
            return System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), OS.class, "uname", securityException);
            return null;
        }
    }

    public static OS current() {
        String string = OS.uname();
        if (string != null) {
            if (string.contains("Windows")) {
                return WINDOWS;
            }
            if (string.contains("Mac OS")) {
                return MAC_OS;
            }
            if (string.contains("Linux")) {
                return LINUX;
            }
        }
        return UNKNOWN;
    }

    public static void load(Class<?> clazz, String string) {
        try {
            System.load(OS.current().nativeLibrary(clazz, string));
        }
        catch (IOException | SecurityException exception) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError(exception.getMessage()).initCause(exception);
        }
    }

    private String nativeLibrary(Class<?> clazz, String string) throws IOException {
        if (this.libdir != null) {
            Serializable serializable;
            String string2;
            int n;
            String string3 = this.unix ? ".so" : ".dll";
            String string4 = this.libdir + '/' + string + string3;
            ClassLoader classLoader = clazz.getClassLoader();
            URL uRL = classLoader.getResource(clazz.getName().replace('.', '/').concat(".class"));
            if (uRL != null && "jar".equals(uRL.getProtocol()) && (n = (string2 = uRL.getPath()).indexOf(33)) >= 0) {
                try {
                    serializable = new File(new URI(string2.substring(0, n)));
                    serializable = new File(((File)serializable).getParentFile(), string4);
                    if (((File)serializable).canExecute()) {
                        return ((File)serializable).getAbsolutePath();
                    }
                }
                catch (IllegalArgumentException | URISyntaxException exception) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), OS.class, "nativeLibrary", exception);
                }
            }
            if ((uRL = classLoader.getResource("native/".concat(string4))) != null) {
                try {
                    return new File(uRL.toURI()).getAbsolutePath();
                }
                catch (IllegalArgumentException | URISyntaxException exception) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), OS.class, "nativeLibrary", exception);
                    Path path = Files.createTempFile(string, string3, new FileAttribute[0]).toAbsolutePath();
                    path.toFile().deleteOnExit();
                    InputStream inputStream = uRL.openStream();
                    serializable = null;
                    try {
                        Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    finally {
                        if (inputStream != null) {
                            if (serializable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                    return path.toString();
                }
            }
        }
        throw new UnsatisfiedLinkError(Errors.format((short)176, OS.uname(), string));
    }
}

