#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::BuyerSatisfactionStatusCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BuyerSatisfactionStatusCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::BuyerSatisfactionStatusCodeType

=head1 DESCRIPTION

Buyer satisfaction status.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Good

You are doing a good job as an eBay seller.
Buyers have been satisfied with your customer service. Be sure to continue
providing members with a positive buying experience.



=cut


use constant Good => scalar('Good');


=head2 NeedsWork

You need to work on your customer service.
Some of your buyers have not been satisfied with your service. Improve your
customer service to earn a higher buyer satisfaction rating.



=cut


use constant NeedsWork => scalar('NeedsWork');


=head2 Poor

You need to improve your selling practices immediately. Too many of your
customers have not been satisfied, and you are at risk of losing your eBay
account.



=cut


use constant Poor => scalar('Poor');


=head2 Unacceptable

Your selling practices are unacceptable.
Improve your selling practices immediately. Your account may be suspended
because of your unacceptable customer service.



=cut


use constant Unacceptable => scalar('Unacceptable');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
