package Locales::DB::Territory::kde;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::kde::VERSION = '0.09';

$Locales::DB::Territory::kde::cldr_version = '2.0';

%Locales::DB::Territory::kde::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Andola',
    'ae'  => "Dimiliki\ dya\ Vakulungwa\ va\ Chalabu",
    'af'  => 'Afuganistani',
    'ag'  => "Antigua\ na\ Balbuda",
    'ai'  => 'Angwila',
    'al'  => 'Albania',
    'am'  => 'Almenia',
    'an'  => "Antili\ za\ Uholanzi",
    'ao'  => 'Angola',
    'aq'  => 'Antarctica',
    'ar'  => 'Adyentina',
    'as'  => "Samoa\ ya\ Malekani",
    'at'  => 'Austlia',
    'au'  => 'Austlalia',
    'aw'  => 'Aluba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Azabadyani',
    'ba'  => "Bosnia\ na\ Hezegovina",
    'bb'  => 'Babadosi',
    'bd'  => 'Bangladeshi',
    'be'  => 'Ubelgidi',
    'bf'  => 'Buchinafaso',
    'bg'  => 'Bulgalia',
    'bh'  => 'Bahaleni',
    'bi'  => 'Bulundi',
    'bj'  => 'Benini',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Belmuda',
    'bn'  => 'Blunei',
    'bo'  => 'Bolivia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Blazili',
    'bs'  => 'Bahama',
    'bt'  => 'Butani',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Botswana',
    'by'  => 'Belalusi',
    'bz'  => 'Belize',
    'ca'  => 'Kanada',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Jamuhuli\ ya\ Chidemoklasia\ ya\ kuKongo",
    'cf'  => "Jamuhuli\ ya\ Afilika\ ya\ Paching\'ati",
    'cg'  => 'Kongo',
    'ch'  => 'Uswisi',
    'ci'  => 'Kodivaa',
    'ck'  => "Chisiwa\ cha\ Cook",
    'cl'  => 'Chile',
    'cm'  => 'Kameluni',
    'cn'  => 'China',
    'co'  => 'Kolombia',
    'cp'  => "Clipperton\ Island",
    'cr'  => 'Kostalika',
    'cs'  => "Selbia\ na\ Monteneglo",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Kuba',
    'cv'  => 'Kepuvede',
    'cx'  => "Christmas\ Island",
    'cy'  => 'Kuplosi',
    'cz'  => "Jamuhuli\ ya\ Chechi",
    'dd'  => "East\ Germany",
    'de'  => 'Udyerumani',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Dyibuti',
    'dk'  => 'Denmaki',
    'dm'  => 'Dominika',
    'do'  => "Jamuhuli\ ya\ Dominika",
    'dz'  => 'Aljelia',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Ekwado',
    'ee'  => 'Estonia',
    'eg'  => 'Misli',
    'eh'  => "Western\ Sahara",
    'er'  => 'Elitilea',
    'es'  => 'Hispania',
    'et'  => 'Uhabeshi',
    'eu'  => "European\ Union",
    'fi'  => 'Ufini',
    'fj'  => 'Fiji',
    'fk'  => "Chisiwa\ cha\ Falkland",
    'fm'  => 'Mikilonesia',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Ufalansa',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gaboni',
    'gb'  => 'Nngalesa',
    'gd'  => 'Glenada',
    'ge'  => 'Dyodya',
    'gf'  => "Gwiyana\ ya\ Ufalansa",
    'gg'  => 'Guernsey',
    'gh'  => 'Ghana',
    'gi'  => 'Diblalta',
    'gl'  => 'Glinlandi',
    'gm'  => 'Gambia',
    'gn'  => 'Gine',
    'gp'  => 'Gwadelupe',
    'gq'  => 'Ginekweta',
    'gr'  => 'Ugilichi',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Gwatemala',
    'gu'  => 'Gwam',
    'gw'  => 'Ginebisau',
    'gy'  => 'Guyana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Hondulasi',
    'hr'  => 'Kolasia',
    'ht'  => 'Haiti',
    'hu'  => 'Hungalia',
    'ic'  => "Canary\ Islands",
    'id'  => 'Indonesia',
    'ie'  => 'Ayalandi',
    'il'  => 'Islaeli',
    'im'  => "Isle\ of\ Man",
    'in'  => 'India',
    'io'  => "Lieneo\ lyaki\ Nngalesa\ Nbahali\ ya\ Hindi",
    'iq'  => 'Ilaki',
    'ir'  => 'Uadyemi',
    'is'  => 'Aislandi',
    'it'  => 'Italia',
    'je'  => 'Jersey',
    'jm'  => 'Dyamaika',
    'jo'  => 'Yordani',
    'jp'  => 'Dyapani',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenya',
    'kg'  => 'Kiligizistani',
    'kh'  => 'Kambodia',
    'ki'  => 'Kilibati',
    'km'  => 'Komolo',
    'kn'  => "Santakitzi\ na\ Nevis",
    'kp'  => "Kolea\ Kasikazini",
    'kr'  => "Kolea\ Kusini",
    'kw'  => 'Kuwaiti',
    'ky'  => "Chisiwa\ cha\ Kemen",
    'kz'  => 'Kazachistani',
    'la'  => 'Laosi',
    'lb'  => 'Lebanoni',
    'lc'  => 'Santalusia',
    'li'  => 'Lishenteni',
    'lk'  => 'Sililanka',
    'lr'  => 'Libelia',
    'ls'  => 'Lesoto',
    'lt'  => 'Litwania',
    'lu'  => 'Lasembagi',
    'lv'  => 'Lativia',
    'ly'  => 'Libya',
    'ma'  => 'Moloko',
    'mc'  => 'Monako',
    'md'  => 'Moldova',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Bukini',
    'mh'  => "Chisiwa\ cha\ Malushal",
    'mi'  => "Midway\ Islands",
    'mk'  => 'Masedonia',
    'ml'  => 'Mali',
    'mm'  => 'Myama',
    'mn'  => 'Mongolia',
    'mo'  => 'Macau',
    'mp'  => "Chisiwa\ cha\ Marian\ cha\ Kasikazini",
    'mq'  => 'Malitiniki',
    'mr'  => 'Molitania',
    'ms'  => 'Monselati',
    'mt'  => 'Malta',
    'mu'  => 'Molisi',
    'mv'  => 'Modivu',
    'mw'  => 'Malawi',
    'mx'  => 'Meksiko',
    'my'  => 'Malesia',
    'mz'  => 'Msumbiji',
    'na'  => 'Namibia',
    'nc'  => 'Nyukaledonia',
    'ne'  => 'Nidyeli',
    'nf'  => "Chisiwa\ cha\ Nolufok",
    'ng'  => 'Nidyelia',
    'ni'  => 'Nikalagwa',
    'nl'  => 'Uholanzi',
    'no'  => 'Norwe',
    'np'  => 'Nepali',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Naulu',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => 'Nyuzilandi',
    'om'  => 'Omani',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Pelu',
    'pf'  => "Polinesia\ ya\ Ufalansa",
    'pg'  => 'Papua',
    'ph'  => 'Filipino',
    'pk'  => 'Pakistani',
    'pl'  => 'Polandi',
    'pm'  => "Santapieli\ na\ Mikeloni",
    'pn'  => 'Pitikeluni',
    'pr'  => 'Pwetoliko',
    'ps'  => "Nchingu\ wa\ Magalibi\ wa\ Mpanda\ wa\ kuGaza\ wa\ kuPales",
    'pt'  => 'Uleno',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Palagwai',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Katali',
    'qo'  => "Outlying\ Oceania",
    're'  => 'Liyunioni',
    'ro'  => 'Lomania',
    'rs'  => 'Serbia',
    'ru'  => 'Ulusi',
    'rw'  => 'Lwanda',
    'sa'  => 'Saudia',
    'sb'  => "Chisiwa\ cha\ Solomon",
    'sc'  => 'Shelisheli',
    'sd'  => 'Sudani',
    'se'  => 'Uswidi',
    'sg'  => 'Singapoo',
    'sh'  => 'Santahelena',
    'si'  => 'Slovenia',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Slovakia',
    'sl'  => "Siela\ Leoni",
    'sm'  => 'Samalino',
    'sn'  => 'Senegali',
    'so'  => 'Somalia',
    'sr'  => 'Sulinamu',
    'st'  => "Saotome\ na\ Prinsipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'Elsavado',
    'sy'  => 'Silia',
    'sz'  => 'Uswazi',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Chisiwa\ cha\ Tuluchi\ na\ Kaiko",
    'td'  => 'Chadi',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Togo',
    'th'  => 'Tailandi',
    'tj'  => 'Tadikistani',
    'tk'  => 'Tokelau',
    'tl'  => "Timoli\ ya\ Mashaliki",
    'tm'  => 'Tuluchimenistani',
    'tn'  => 'Tunisia',
    'to'  => 'Tonga',
    'tr'  => 'Utuluchi',
    'tt'  => "Tilinidad\ na\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Taiwani',
    'tz'  => 'Tanzania',
    'ua'  => 'Uklaini',
    'ug'  => 'Uganda',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => 'Malekani',
    'uy'  => 'Ulugwai',
    'uz'  => 'Uzibechistani',
    'va'  => 'Vatikani',
    'vc'  => "Santavisenti\ na\ Glenadini",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "Chisiwa\ Chivihi\ cha\ Wingalesa",
    'vi'  => "Chisiwa\ Chivihi\ cha\ Malekani",
    'vn'  => 'Vietinamu',
    'vu'  => 'Vanuatu',
    'wf'  => "Walis\ na\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemeni',
    'yt'  => 'Maole',
    'za'  => "Afilika\ Kusini",
    'zm'  => 'Zambia',
    'zw'  => 'Zimbabwe',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::kde::name_to_code = (
    'adyentina'                                  => 'ar',
    'afilikakusini'                              => 'za',
    'africa'                                     => '002',
    'afuganistani'                               => 'af',
    'aislandi'                                   => 'is',
    'albania'                                    => 'al',
    'aljelia'                                    => 'dz',
    'almenia'                                    => 'am',
    'aluba'                                      => 'aw',
    'americas'                                   => '019',
    'andola'                                     => 'ad',
    'angola'                                     => 'ao',
    'angwila'                                    => 'ai',
    'antarctica'                                 => 'aq',
    'antiguanabalbuda'                           => 'ag',
    'antilizauholanzi'                           => 'an',
    'ascensionisland'                            => 'ac',
    'asia'                                       => 142,
    'austlalia'                                  => 'au',
    'austlia'                                    => 'at',
    'australiaandnewzealand'                     => '053',
    'ayalandi'                                   => 'ie',
    'azabadyani'                                 => 'az',
    'babadosi'                                   => 'bb',
    'bahaleni'                                   => 'bh',
    'bahama'                                     => 'bs',
    'bangladeshi'                                => 'bd',
    'belalusi'                                   => 'by',
    'belize'                                     => 'bz',
    'belmuda'                                    => 'bm',
    'benini'                                     => 'bj',
    'blazili'                                    => 'br',
    'blunei'                                     => 'bn',
    'bolivia'                                    => 'bo',
    'bosnianahezegovina'                         => 'ba',
    'botswana'                                   => 'bw',
    'bouvetisland'                               => 'bv',
    'britishantarcticterritory'                  => 'bq',
    'buchinafaso'                                => 'bf',
    'bukini'                                     => 'mg',
    'bulgalia'                                   => 'bg',
    'bulundi'                                    => 'bi',
    'butani'                                     => 'bt',
    'canaryislands'                              => 'ic',
    'cantonandenderburyislands'                  => 'ct',
    'caribbean'                                  => '029',
    'centralamerica'                             => '013',
    'centralasia'                                => 143,
    'ceutaandmelilla'                            => 'ea',
    'chadi'                                      => 'td',
    'channelislands'                             => 830,
    'chile'                                      => 'cl',
    'china'                                      => 'cn',
    'chisiwachacook'                             => 'ck',
    'chisiwachafalkland'                         => 'fk',
    'chisiwachakemen'                            => 'ky',
    'chisiwachamalushal'                         => 'mh',
    'chisiwachamarianchakasikazini'              => 'mp',
    'chisiwachanolufok'                          => 'nf',
    'chisiwachasolomon'                          => 'sb',
    'chisiwachatuluchinakaiko'                   => 'tc',
    'chisiwachivihichamalekani'                  => 'vi',
    'chisiwachivihichawingalesa'                 => 'vg',
    'christmasisland'                            => 'cx',
    'clippertonisland'                           => 'cp',
    'cocoskeelingislands'                        => 'cc',
    'commonwealthofindependentstates'            => 172,
    'czechoslovakia'                             => 200,
    'denmaki'                                    => 'dk',
    'diblalta'                                   => 'gi',
    'diegogarcia'                                => 'dg',
    'dimilikidyavakulungwavachalabu'             => 'ae',
    'dominika'                                   => 'dm',
    'dronningmaudland'                           => 'nq',
    'dyamaika'                                   => 'jm',
    'dyapani'                                    => 'jp',
    'dyibuti'                                    => 'dj',
    'dyodya'                                     => 'ge',
    'easternafrica'                              => '014',
    'easternasia'                                => '030',
    'easterneurope'                              => 151,
    'eastgermany'                                => 'dd',
    'ekwado'                                     => 'ec',
    'elitilea'                                   => 'er',
    'elsavado'                                   => 'sv',
    'estonia'                                    => 'ee',
    'europe'                                     => 150,
    'europeanunion'                              => 'eu',
    'faroeislands'                               => 'fo',
    'fiji'                                       => 'fj',
    'filipino'                                   => 'ph',
    'frenchsouthernandantarcticterritories'      => 'fq',
    'frenchsouthernterritories'                  => 'tf',
    'gaboni'                                     => 'ga',
    'gambia'                                     => 'gm',
    'ghana'                                      => 'gh',
    'gine'                                       => 'gn',
    'ginebisau'                                  => 'gw',
    'ginekweta'                                  => 'gq',
    'glenada'                                    => 'gd',
    'glinlandi'                                  => 'gl',
    'guernsey'                                   => 'gg',
    'guyana'                                     => 'gy',
    'gwadelupe'                                  => 'gp',
    'gwam'                                       => 'gu',
    'gwatemala'                                  => 'gt',
    'gwiyanayaufalansa'                          => 'gf',
    'haiti'                                      => 'ht',
    'heardislandandmcdonaldislands'              => 'hm',
    'hispania'                                   => 'es',
    'hondulasi'                                  => 'hn',
    'hongkong'                                   => 'hk',
    'hungalia'                                   => 'hu',
    'ilaki'                                      => 'iq',
    'india'                                      => 'in',
    'indonesia'                                  => 'id',
    'islaeli'                                    => 'il',
    'isleofman'                                  => 'im',
    'italia'                                     => 'it',
    'jamuhuliyaafilikayapachingati'              => 'cf',
    'jamuhuliyachechi'                           => 'cz',
    'jamuhuliyachidemoklasiayakukongo'           => 'cd',
    'jamuhuliyadominika'                         => 'do',
    'jersey'                                     => 'je',
    'johnstonisland'                             => 'jt',
    'kambodia'                                   => 'kh',
    'kameluni'                                   => 'cm',
    'kanada'                                     => 'ca',
    'katali'                                     => 'qa',
    'kazachistani'                               => 'kz',
    'kenya'                                      => 'ke',
    'kepuvede'                                   => 'cv',
    'kilibati'                                   => 'ki',
    'kiligizistani'                              => 'kg',
    'kodivaa'                                    => 'ci',
    'kolasia'                                    => 'hr',
    'koleakasikazini'                            => 'kp',
    'koleakusini'                                => 'kr',
    'kolombia'                                   => 'co',
    'komolo'                                     => 'km',
    'kongo'                                      => 'cg',
    'kostalika'                                  => 'cr',
    'kuba'                                       => 'cu',
    'kuplosi'                                    => 'cy',
    'kuwaiti'                                    => 'kw',
    'laosi'                                      => 'la',
    'lasembagi'                                  => 'lu',
    'latinamerica'                               => 419,
    'lativia'                                    => 'lv',
    'lebanoni'                                   => 'lb',
    'lesoto'                                     => 'ls',
    'libelia'                                    => 'lr',
    'libya'                                      => 'ly',
    'lieneolyakinngalesanbahaliyahindi'          => 'io',
    'lishenteni'                                 => 'li',
    'litwania'                                   => 'lt',
    'liyunioni'                                  => 're',
    'lomania'                                    => 'ro',
    'lwanda'                                     => 'rw',
    'macau'                                      => 'mo',
    'malawi'                                     => 'mw',
    'malekani'                                   => 'us',
    'malesia'                                    => 'my',
    'mali'                                       => 'ml',
    'malitiniki'                                 => 'mq',
    'malta'                                      => 'mt',
    'maole'                                      => 'yt',
    'masedonia'                                  => 'mk',
    'meksiko'                                    => 'mx',
    'melanesia'                                  => '054',
    'metropolitanfrance'                         => 'fx',
    'micronesianregion'                          => '057',
    'middleafrica'                               => '017',
    'midwayislands'                              => 'mi',
    'mikilonesia'                                => 'fm',
    'misli'                                      => 'eg',
    'modivu'                                     => 'mv',
    'moldova'                                    => 'md',
    'molisi'                                     => 'mu',
    'molitania'                                  => 'mr',
    'moloko'                                     => 'ma',
    'monako'                                     => 'mc',
    'mongolia'                                   => 'mn',
    'monselati'                                  => 'ms',
    'montenegro'                                 => 'me',
    'msumbiji'                                   => 'mz',
    'myama'                                      => 'mm',
    'namibia'                                    => 'na',
    'naulu'                                      => 'nr',
    'nchinguwamagalibiwampandawakugazawakupales' => 'ps',
    'nepali'                                     => 'np',
    'neutralzone'                                => 'nt',
    'nidyeli'                                    => 'ne',
    'nidyelia'                                   => 'ng',
    'nikalagwa'                                  => 'ni',
    'niue'                                       => 'nu',
    'nngalesa'                                   => 'gb',
    'northamerica'                               => '003',
    'northernafrica'                             => '015',
    'northernamerica'                            => '021',
    'northerneurope'                             => 154,
    'northvietnam'                               => 'vd',
    'norwe'                                      => 'no',
    'nyukaledonia'                               => 'nc',
    'nyuzilandi'                                 => 'nz',
    'oceania'                                    => '009',
    'omani'                                      => 'om',
    'outlyingoceania'                            => 'qo',
    'pacificislandstrustterritory'               => 'pc',
    'pakistani'                                  => 'pk',
    'palagwai'                                   => 'py',
    'palau'                                      => 'pw',
    'panama'                                     => 'pa',
    'panamacanalzone'                            => 'pz',
    'papua'                                      => 'pg',
    'pelu'                                       => 'pe',
    "people\â\\sdemocraticrepublicofyemen"  => 'yd',
    'pitikeluni'                                 => 'pn',
    'polandi'                                    => 'pl',
    'polinesiayaufalansa'                        => 'pf',
    'polynesia'                                  => '061',
    'pwetoliko'                                  => 'pr',
    "saintbarth\Ã\©lemy"                       => 'bl',
    'saintmartin'                                => 'mf',
    'samalino'                                   => 'sm',
    'samoa'                                      => 'ws',
    'samoayamalekani'                            => 'as',
    'santahelena'                                => 'sh',
    'santakitzinanevis'                          => 'kn',
    'santalusia'                                 => 'lc',
    'santapielinamikeloni'                       => 'pm',
    'santavisentinaglenadini'                    => 'vc',
    'saotomenaprinsipe'                          => 'st',
    'saudia'                                     => 'sa',
    'selbianamonteneglo'                         => 'cs',
    'senegali'                                   => 'sn',
    'serbia'                                     => 'rs',
    'shelisheli'                                 => 'sc',
    'sielaleoni'                                 => 'sl',
    'silia'                                      => 'sy',
    'sililanka'                                  => 'lk',
    'singapoo'                                   => 'sg',
    'slovakia'                                   => 'sk',
    'slovenia'                                   => 'si',
    'somalia'                                    => 'so',
    'southamerica'                               => '005',
    'southcentralasia'                           => '062',
    'southeasternasia'                           => '035',
    'southernafrica'                             => '018',
    'southernasia'                               => '034',
    'southerneurope'                             => '039',
    'southgeorgiaandthesouthsandwichislands'     => 'gs',
    'sudani'                                     => 'sd',
    'sulinamu'                                   => 'sr',
    'svalbardandjanmayen'                        => 'sj',
    'tadikistani'                                => 'tj',
    'tailandi'                                   => 'th',
    'taiwani'                                    => 'tw',
    'tanzania'                                   => 'tz',
    'tilinidadnatobago'                          => 'tt',
    'timoliyamashaliki'                          => 'tl',
    'togo'                                       => 'tg',
    'tokelau'                                    => 'tk',
    'tonga'                                      => 'to',
    'tristandacunha'                             => 'ta',
    'tuluchimenistani'                           => 'tm',
    'tunisia'                                    => 'tn',
    'tuvalu'                                     => 'tv',
    "u\.s\.minoroutlyingislands"                 => 'um',
    "u\.s\.miscellaneouspacificislands"          => 'pu',
    'uadyemi'                                    => 'ir',
    'ubelgidi'                                   => 'be',
    'udyerumani'                                 => 'de',
    'ufalansa'                                   => 'fr',
    'ufini'                                      => 'fi',
    'uganda'                                     => 'ug',
    'ugilichi'                                   => 'gr',
    'uhabeshi'                                   => 'et',
    'uholanzi'                                   => 'nl',
    'uklaini'                                    => 'ua',
    'uleno'                                      => 'pt',
    'ulugwai'                                    => 'uy',
    'ulusi'                                      => 'ru',
    'unionofsovietsocialistrepublics'            => 'su',
    'unknownregion'                              => 'zz',
    'uswazi'                                     => 'sz',
    'uswidi'                                     => 'se',
    'uswisi'                                     => 'ch',
    'utuluchi'                                   => 'tr',
    'uzibechistani'                              => 'uz',
    'vanuatu'                                    => 'vu',
    'vatikani'                                   => 'va',
    'venezuela'                                  => 've',
    'vietinamu'                                  => 'vn',
    'wakeisland'                                 => 'wk',
    'walisnafutuna'                              => 'wf',
    'westernafrica'                              => '011',
    'westernasia'                                => 145,
    'westerneurope'                              => 155,
    'westernsahara'                              => 'eh',
    'world'                                      => '001',
    'yemeni'                                     => 'ye',
    'yordani'                                    => 'jo',
    'zambia'                                     => 'zm',
    'zimbabwe'                                   => 'zw',
    "\Ã\landislands"                          => 'ax',
);

1;

