# Generated by default/object.tt
package Paws::SageMaker::CognitoConfig;
  use Moose;
  has ClientId => (is => 'ro', isa => 'Str', required => 1);
  has UserPool => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::CognitoConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::CognitoConfig object:

  $service_obj->Method(Att1 => { ClientId => $value, ..., UserPool => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::CognitoConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ClientId

=head1 DESCRIPTION

Use this parameter to configure your Amazon Cognito workforce. A single
Cognito workforce is created using and corresponds to a single Amazon
Cognito user pool
(https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> ClientId => Str

The client ID for your Amazon Cognito user pool.


=head2 B<REQUIRED> UserPool => Str

A user pool
(https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html)
is a user directory in Amazon Cognito. With a user pool, your users can
sign in to your web or mobile app through Amazon Cognito. Your users
can also sign in through social identity providers like Google,
Facebook, Amazon, or Apple, and through SAML identity providers.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

