/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.model;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.common.model.dimension.Histogram;
import org.opensearch.indexmanagement.common.model.dimension.Terms;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B?\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\nH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0003J\t\u0010#\u001a\u00020\u0011H\u00c6\u0003JK\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020\nH\u00d6\u0001J\b\u0010*\u001a\u00020\u0007H\u0016J\u001a\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00072\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/J\u001a\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018\u00a8\u0006:"}, d2={"Lorg/opensearch/indexmanagement/transform/model/ISMTransform;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "description", "", "targetIndex", "pageSize", "", "dataSelectionQuery", "Lorg/opensearch/index/query/QueryBuilder;", "groups", "", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "aggregations", "Lorg/opensearch/search/aggregations/AggregatorFactories$Builder;", "(Ljava/lang/String;Ljava/lang/String;ILorg/opensearch/index/query/QueryBuilder;Ljava/util/List;Lorg/opensearch/search/aggregations/AggregatorFactories$Builder;)V", "getAggregations", "()Lorg/opensearch/search/aggregations/AggregatorFactories$Builder;", "getDataSelectionQuery", "()Lorg/opensearch/index/query/QueryBuilder;", "getDescription", "()Ljava/lang/String;", "getGroups", "()Ljava/util/List;", "getPageSize", "()I", "getTargetIndex", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "toString", "toTransform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "sourceIndex", "user", "Lorg/opensearch/commons/authuser/User;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nISMTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ISMTransform.kt\norg/opensearch/indexmanagement/transform/model/ISMTransform\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1#2:211\n1855#3,2:212\n1855#3,2:214\n*S KotlinDebug\n*F\n+ 1 ISMTransform.kt\norg/opensearch/indexmanagement/transform/model/ISMTransform\n*L\n56#1:212,2\n129#1:214,2\n*E\n"})
public final class ISMTransform
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String description;
    @NotNull
    private final String targetIndex;
    private final int pageSize;
    @NotNull
    private final QueryBuilder dataSelectionQuery;
    @NotNull
    private final List<Dimension> groups;
    @NotNull
    private final AggregatorFactories.Builder aggregations;

    public ISMTransform(@NotNull String description, @NotNull String targetIndex, int pageSize, @NotNull QueryBuilder dataSelectionQuery, @NotNull List<? extends Dimension> groups, @NotNull AggregatorFactories.Builder aggregations) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter((Object)dataSelectionQuery, (String)"dataSelectionQuery");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)aggregations, (String)"aggregations");
        this.description = description;
        this.targetIndex = targetIndex;
        this.pageSize = pageSize;
        this.dataSelectionQuery = dataSelectionQuery;
        this.groups = groups;
        this.aggregations = aggregations;
        int n = this.pageSize;
        if (!(1 <= n ? n < 10001 : false)) {
            boolean $i$a$-require-ISMTransform$52 = false;
            String $i$a$-require-ISMTransform$52 = "Page size must be between 1 and 10000";
            throw new IllegalArgumentException($i$a$-require-ISMTransform$52.toString());
        }
        if (!(((CharSequence)this.description).length() > 0)) {
            boolean $i$a$-require-ISMTransform$62 = false;
            String $i$a$-require-ISMTransform$62 = "Description cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ISMTransform$62.toString());
        }
        if (!(((CharSequence)this.targetIndex).length() > 0)) {
            boolean $i$a$-require-ISMTransform$72 = false;
            String $i$a$-require-ISMTransform$72 = "TargetIndex cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ISMTransform$72.toString());
        }
        if (!(!((Collection)this.groups).isEmpty())) {
            boolean $i$a$-require-ISMTransform$82 = false;
            String $i$a$-require-ISMTransform$82 = "Groups cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ISMTransform$82.toString());
        }
        Collection collection = this.aggregations.getAggregatorFactories();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"aggregations.aggregatorFactories");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AggregationBuilder it = (AggregationBuilder)element$iv;
            boolean bl = false;
            if (Transform.Companion.getSupportedAggregations().contains(it.getType())) continue;
            boolean bl2 = false;
            String string = "Unsupported aggregation [" + it.getType() + "]";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ISMTransform(String string, String string2, int n, QueryBuilder queryBuilder, List list, AggregatorFactories.Builder builder, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            queryBuilder = (QueryBuilder)new MatchAllQueryBuilder();
        }
        if ((n2 & 0x20) != 0) {
            AggregatorFactories.Builder builder2 = AggregatorFactories.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder()");
            builder = builder2;
        }
        this(string, string2, n, queryBuilder, list, builder);
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getTargetIndex() {
        return this.targetIndex;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @NotNull
    public final QueryBuilder getDataSelectionQuery() {
        return this.dataSelectionQuery;
    }

    @NotNull
    public final List<Dimension> getGroups() {
        return this.groups;
    }

    @NotNull
    public final AggregatorFactories.Builder getAggregations() {
        return this.aggregations;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.startObject().field("description", this.description).field("target_index", this.targetIndex).field("page_size", this.pageSize).field("data_selection_query", (ToXContent)this.dataSelectionQuery).field("groups", (Iterable)this.groups).field("aggregations", (ToXContent)this.aggregations);
        builder.endObject();
        return builder;
    }

    @NotNull
    public final Transform toTransform(@NotNull String sourceIndex, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        String id2 = sourceIndex + this;
        Instant currentTime = Instant.now();
        String string = DigestUtils.sha1Hex((String)id2);
        IntervalSchedule intervalSchedule = new IntervalSchedule(Instant.now(), 1, ChronoUnit.MINUTES);
        String string2 = this.description;
        QueryBuilder queryBuilder = this.dataSelectionQuery;
        String string3 = this.targetIndex;
        int n = this.pageSize;
        List<Dimension> list = this.groups;
        AggregatorFactories.Builder builder = this.aggregations;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sha1Hex(id)");
        Schedule schedule = (Schedule)intervalSchedule;
        Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
        return new Transform(string, -2L, 0L, 1L, schedule, null, currentTime, true, currentTime, string2, sourceIndex, queryBuilder, string3, null, n, list, builder, false, user, 8192, null);
    }

    public static /* synthetic */ Transform toTransform$default(ISMTransform iSMTransform, String string, User user, int n, Object object) {
        if ((n & 2) != 0) {
            user = null;
        }
        return iSMTransform.toTransform(string, user);
    }

    /*
     * WARNING - void declaration
     */
    public ISMTransform(@NotNull StreamInput sin) throws IOException {
        void it;
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        ISMTransform iSMTransform = this;
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
        int n = sin.readInt();
        NamedWriteable namedWriteable = sin.readOptionalNamedWriteable(QueryBuilder.class);
        if (namedWriteable == null) {
            int n2 = n;
            String string3 = string2;
            String string4 = string;
            ISMTransform iSMTransform2 = iSMTransform;
            boolean $i$a$-requireNotNull-ISMTransform$72 = false;
            String string5 = "Query cannot be null";
            ISMTransform iSMTransform3 = iSMTransform2;
            String string6 = string4;
            String string7 = string3;
            int n3 = n2;
            String $i$a$-requireNotNull-ISMTransform$72 = string5;
            throw new IllegalArgumentException($i$a$-requireNotNull-ISMTransform$72.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)namedWriteable, (String)"requireNotNull(sin.readO\u2026 \"Query cannot be null\" }");
        StreamInput streamInput = sin;
        QueryBuilder queryBuilder = (QueryBuilder)namedWriteable;
        int n4 = n;
        String string8 = string2;
        String string9 = string;
        ISMTransform iSMTransform4 = iSMTransform;
        boolean bl = false;
        List dimensionList = new ArrayList();
        int size = it.readVInt();
        for (int i = 0; i < size; ++i) {
            Dimension dimension;
            boolean bl2 = false;
            Dimension.Type type = (Dimension.Type)it.readEnum(Dimension.Type.class);
            List list = dimensionList;
            Dimension.Type type2 = type;
            if (type2 == null) {
                List list2 = list;
                boolean bl3 = false;
                List list3 = list2;
                String string10 = "Dimension type cannot be null";
                throw new IllegalArgumentException(string10.toString());
            }
            switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    dimension = new DateHistogram(sin);
                    break;
                }
                case 2: {
                    dimension = new Terms(sin);
                    break;
                }
                case 3: {
                    dimension = new Histogram(sin);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            list.add(dimension);
        }
        List list = CollectionsKt.toList((Iterable)dimensionList);
        ISMTransform iSMTransform5 = iSMTransform4;
        String string11 = string9;
        String string12 = string8;
        int n5 = n4;
        QueryBuilder queryBuilder2 = queryBuilder;
        List list4 = list;
        Writeable writeable = sin.readOptionalWriteable(ISMTransform::_init_$lambda$10);
        if (writeable == null) {
            list = list4;
            queryBuilder = queryBuilder2;
            n4 = n5;
            string8 = string12;
            string9 = string11;
            iSMTransform4 = iSMTransform5;
            boolean bl4 = false;
            String string13 = "Aggregations cannot be null";
            ISMTransform iSMTransform6 = iSMTransform4;
            String string14 = string9;
            String string15 = string8;
            int n6 = n4;
            QueryBuilder queryBuilder3 = queryBuilder;
            List list5 = list;
            String string16 = string13;
            throw new IllegalArgumentException(string16.toString());
        }
        iSMTransform5(string11, string12, n5, queryBuilder2, list4, (AggregatorFactories.Builder)writeable);
    }

    @NotNull
    public String toString() {
        StringBuilder sbd = new StringBuilder();
        sbd.append(this.targetIndex);
        sbd.append(this.pageSize);
        sbd.append(this.dataSelectionQuery);
        Iterable $this$forEach$iv = this.groups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dimension it = (Dimension)element$iv;
            boolean bl = false;
            sbd.append((Object)it.getType());
            sbd.append(it.getSourceField());
        }
        sbd.append(this.aggregations);
        String string = sbd.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sbd.toString()");
        return string;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.description);
        out.writeString(this.targetIndex);
        out.writeInt(this.pageSize);
        out.writeOptionalNamedWriteable((NamedWriteable)this.dataSelectionQuery);
        out.writeVInt(this.groups.size());
        for (Dimension group : this.groups) {
            out.writeEnum((Enum)group.getType());
            Dimension dimension = group;
            if (dimension instanceof DateHistogram) {
                group.writeTo(out);
                continue;
            }
            if (dimension instanceof Terms) {
                group.writeTo(out);
                continue;
            }
            if (!(dimension instanceof Histogram)) continue;
            group.writeTo(out);
        }
        out.writeOptionalWriteable((Writeable)this.aggregations);
    }

    @NotNull
    public final String component1() {
        return this.description;
    }

    @NotNull
    public final String component2() {
        return this.targetIndex;
    }

    public final int component3() {
        return this.pageSize;
    }

    @NotNull
    public final QueryBuilder component4() {
        return this.dataSelectionQuery;
    }

    @NotNull
    public final List<Dimension> component5() {
        return this.groups;
    }

    @NotNull
    public final AggregatorFactories.Builder component6() {
        return this.aggregations;
    }

    @NotNull
    public final ISMTransform copy(@NotNull String description, @NotNull String targetIndex, int pageSize, @NotNull QueryBuilder dataSelectionQuery, @NotNull List<? extends Dimension> groups, @NotNull AggregatorFactories.Builder aggregations) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter((Object)dataSelectionQuery, (String)"dataSelectionQuery");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)aggregations, (String)"aggregations");
        return new ISMTransform(description, targetIndex, pageSize, dataSelectionQuery, groups, aggregations);
    }

    public static /* synthetic */ ISMTransform copy$default(ISMTransform iSMTransform, String string, String string2, int n, QueryBuilder queryBuilder, List list, AggregatorFactories.Builder builder, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = iSMTransform.description;
        }
        if ((n2 & 2) != 0) {
            string2 = iSMTransform.targetIndex;
        }
        if ((n2 & 4) != 0) {
            n = iSMTransform.pageSize;
        }
        if ((n2 & 8) != 0) {
            queryBuilder = iSMTransform.dataSelectionQuery;
        }
        if ((n2 & 0x10) != 0) {
            list = iSMTransform.groups;
        }
        if ((n2 & 0x20) != 0) {
            builder = iSMTransform.aggregations;
        }
        return iSMTransform.copy(string, string2, n, queryBuilder, list, builder);
    }

    public int hashCode() {
        int result2 = this.description.hashCode();
        result2 = result2 * 31 + this.targetIndex.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.pageSize);
        result2 = result2 * 31 + this.dataSelectionQuery.hashCode();
        result2 = result2 * 31 + ((Object)this.groups).hashCode();
        result2 = result2 * 31 + this.aggregations.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ISMTransform)) {
            return false;
        }
        ISMTransform iSMTransform = (ISMTransform)other;
        if (!Intrinsics.areEqual((Object)this.description, (Object)iSMTransform.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetIndex, (Object)iSMTransform.targetIndex)) {
            return false;
        }
        if (this.pageSize != iSMTransform.pageSize) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dataSelectionQuery, (Object)iSMTransform.dataSelectionQuery)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.groups, iSMTransform.groups)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.aggregations, (Object)iSMTransform.aggregations);
    }

    private static final AggregatorFactories.Builder _init_$lambda$10(StreamInput it) {
        return new AggregatorFactories.Builder(it);
    }

    @JvmStatic
    @NotNull
    public static final ISMTransform parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/indexmanagement/transform/model/ISMTransform$Companion;", "", "()V", "parse", "Lorg/opensearch/indexmanagement/transform/model/ISMTransform;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ISMTransform parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String description = "";
            String targetIndex = "";
            int pageSize = 0;
            QueryBuilder dataSelectionQuery = (QueryBuilder)new MatchAllQueryBuilder();
            List groups = new ArrayList();
            AggregatorFactories.Builder builder = AggregatorFactories.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
            AggregatorFactories.Builder aggregations = builder;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block16: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block24: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block24;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -207303516: {
                            if (string.equals("target_index")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1723024832: {
                            if (string.equals("data_selection_query")) {
                                n = 2;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (string.equals("description")) {
                                n = 3;
                            }
                            break;
                        }
                        case -1237460524: {
                            if (string.equals("groups")) {
                                n = 4;
                            }
                            break;
                        }
                        case 317470161: {
                            if (string.equals("aggregations")) {
                                n = 5;
                            }
                            break;
                        }
                        case 883849137: {
                            if (string.equals("page_size")) {
                                n = 6;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                            continue block16;
                        }
                        case 1: {
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                            continue block16;
                        }
                        case 6: {
                            pageSize = xcp.intValue();
                            continue block16;
                        }
                        case 2: {
                            NamedXContentRegistry registry = xcp.getXContentRegistry();
                            Map source = xcp.mapOrdered();
                            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
                            XContentParser sourceParser = XContentType.JSON.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)xContentBuilder).streamInput());
                            Intrinsics.checkNotNullExpressionValue((Object)AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)sourceParser), (String)"parseInnerQueryBuilder(sourceParser)");
                            continue block16;
                        }
                        case 4: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                groups.add(Dimension.Companion.parse(xcp));
                            }
                            continue block16;
                        }
                        case 5: {
                            Intrinsics.checkNotNullExpressionValue((Object)AggregatorFactories.parseAggregators((XContentParser)xcp), (String)"parseAggregators(xcp)");
                            continue block16;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in ISM Transform.");
            }
            return new ISMTransform(description, targetIndex, pageSize, dataSelectionQuery, groups, aggregations);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Dimension.Type.values().length];
            try {
                nArray[Dimension.Type.DATE_HISTOGRAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.TERMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.HISTOGRAM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

