/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.infotheory.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.tribuo.util.infotheory.impl.Row;

public final class RowList<T>
implements List<Row<T>> {
    private final Set<List<T>> set;
    private final int size;

    public RowList(Set<List<T>> set) {
        this.set = Collections.unmodifiableSet(new LinkedHashSet<List<T>>(set));
        this.size = set.iterator().next().size();
        for (Collection collection : this.set) {
            if (this.size == collection.size()) continue;
            throw new IllegalArgumentException("Not all the collections in the set are the same length");
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Row) {
            Row otherRow = (Row)o;
            boolean found = false;
            for (Row<T> row : this) {
                if (!otherRow.equals(row)) continue;
                found = true;
                break;
            }
            return found;
        }
        return false;
    }

    @Override
    public Iterator<Row<T>> iterator() {
        return new RowListIterator<T>(this.set);
    }

    @Override
    public Object[] toArray() {
        Object[] output = new Object[this.size];
        int counter = 0;
        Iterator<Row<T>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Row<T> row;
            output[counter] = row = iterator.next();
            ++counter;
        }
        return output;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        Object[] output = a;
        if (output.length < this.size) {
            output = (Object[])Array.newInstance(a[0].getClass(), this.size);
        }
        int counter = 0;
        for (Row<T> row : this) {
            output[counter] = row;
            ++counter;
        }
        if (output.length > this.size) {
            while (counter < output.length) {
                output[counter] = null;
                ++counter;
            }
        }
        return output;
    }

    @Override
    public Row<T> get(int index) {
        ArrayList<T> list = new ArrayList<T>(this.set.size());
        int counter = 0;
        for (List<T> element : this.set) {
            list.add(counter, element.get(index));
            ++counter;
        }
        return new Row(list);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean found = true;
        Iterator<?> itr = c.iterator();
        while (itr.hasNext() && found) {
            found = this.contains(itr.next());
        }
        return found;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Row) {
            Row otherRow = (Row)o;
            int counter = 0;
            int found = -1;
            Iterator<Row<T>> itr = this.iterator();
            while (itr.hasNext() && found == -1) {
                if (itr.next().equals(otherRow)) {
                    found = counter;
                }
                ++counter;
            }
            return found;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Row) {
            Row otherRow = (Row)o;
            int counter = 0;
            int found = -1;
            for (Row<T> tRow : this) {
                if (tRow.equals(otherRow)) {
                    found = counter;
                }
                ++counter;
            }
            return found;
        }
        return -1;
    }

    @Override
    public ListIterator<Row<T>> listIterator() {
        return new RowListIterator<T>(this.set);
    }

    @Override
    public ListIterator<Row<T>> listIterator(int index) {
        return new RowListIterator<T>(this.set, index);
    }

    @Override
    public List<Row<T>> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Views are not supported on a RowList.");
    }

    @Override
    public boolean add(Row<T> e) {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    @Override
    public boolean addAll(Collection<? extends Row<T>> c) {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Row<T>> c) {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    @Override
    public Row<T> set(int index, Row<T> element) {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    @Override
    public void add(int index, Row<T> element) {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    @Override
    public Row<T> remove(int index) {
        throw new UnsupportedOperationException("This list is immutable.");
    }

    private static class RowListIterator<T>
    implements ListIterator<Row<T>> {
        private int curIndex;
        private final int size;
        private final Set<List<T>> set;

        public RowListIterator(Set<List<T>> set) {
            this(set, 0);
        }

        public RowListIterator(Set<List<T>> set, int curIndex) {
            this.curIndex = curIndex;
            this.set = set;
            this.size = set.iterator().next().size();
        }

        @Override
        public boolean hasNext() {
            return this.curIndex < this.size;
        }

        @Override
        public Row<T> next() {
            ArrayList<T> list = new ArrayList<T>(this.set.size());
            int counter = 0;
            for (List<T> element : this.set) {
                list.add(counter, element.get(this.curIndex));
                ++counter;
            }
            ++this.curIndex;
            return new Row(list);
        }

        @Override
        public boolean hasPrevious() {
            return this.curIndex > 0;
        }

        @Override
        public Row<T> previous() {
            ArrayList<T> list = new ArrayList<T>(this.set.size());
            --this.curIndex;
            int counter = 0;
            for (List<T> element : this.set) {
                list.add(counter, element.get(this.curIndex));
                ++counter;
            }
            return new Row(list);
        }

        @Override
        public int nextIndex() {
            return this.curIndex;
        }

        @Override
        public int previousIndex() {
            return this.curIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The list backing this iterator is immutable.");
        }

        @Override
        public void set(Row<T> e) {
            throw new UnsupportedOperationException("The list backing this iterator is immutable.");
        }

        @Override
        public void add(Row<T> e) {
            throw new UnsupportedOperationException("The list backing this iterator is immutable.");
        }
    }
}

