/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.tracker;

import ai.djl.training.tracker.FactorTracker;
import ai.djl.training.tracker.Tracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFactorTracker
implements Tracker {
    private static final Logger logger = LoggerFactory.getLogger(FactorTracker.class);
    private float baseValue;
    private int[] steps;
    private float factor;
    private int stepIndex;

    public MultiFactorTracker(Builder builder) {
        this.baseValue = builder.baseValue;
        this.steps = builder.steps;
        this.factor = builder.factor;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public float getNewValue(int numUpdate) {
        while (this.stepIndex <= this.steps.length - 1) {
            if (numUpdate > this.steps[this.stepIndex]) {
                ++this.stepIndex;
                this.baseValue *= this.factor;
                logger.debug("Update[{}]: Change tracker value to {}", (Object)numUpdate, (Object)String.format("%.5e", Float.valueOf(this.baseValue)));
                continue;
            }
            return this.baseValue;
        }
        return this.baseValue;
    }

    public static final class Builder {
        float baseValue;
        int[] steps;
        float factor = 1.0f;

        private Builder() {
        }

        public Builder setBaseValue(float baseValue) {
            this.baseValue = baseValue;
            return this;
        }

        public Builder setSteps(int[] steps) {
            if (steps.length <= 1) {
                throw new IllegalArgumentException("Steps should be an array of integers indicating when the value should be changed, usually in an uneven interval of stepsuse FactorTracker if you want the value to be changed at a constant interval of steps");
            }
            for (int i = 0; i < steps.length; ++i) {
                if (i > 0 && steps[i] <= steps[i - 1]) {
                    throw new IllegalArgumentException("Steps must be an increasing list");
                }
                if (steps[i] >= 1) continue;
                throw new IllegalArgumentException("Step must be larger or equal to 1");
            }
            this.steps = steps;
            return this;
        }

        public Builder optFactor(float factor) {
            if (factor > 1.0f) {
                throw new IllegalArgumentException("factor should be no more than 1");
            }
            this.factor = factor;
            return this;
        }

        public MultiFactorTracker build() {
            if (this.steps == null) {
                throw new IllegalArgumentException("Steps must be set to change value");
            }
            return new MultiFactorTracker(this);
        }
    }
}

