/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.data.text.DocumentPreprocessor;
import org.tribuo.data.text.TextDataSource;
import org.tribuo.data.text.TextFeatureExtractor;
import org.tribuo.provenance.ConfiguredDataSourceProvenance;

public class SimpleTextDataSource<T extends Output<T>>
extends TextDataSource<T> {
    private static final Logger logger = Logger.getLogger(SimpleTextDataSource.class.getName());
    private static final Pattern splitPattern = Pattern.compile("##");
    protected ConfiguredDataSourceProvenance provenance;

    protected SimpleTextDataSource() {
    }

    public SimpleTextDataSource(Path path, OutputFactory<T> outputFactory, TextFeatureExtractor<T> extractor) throws IOException {
        super(path, outputFactory, extractor, new DocumentPreprocessor[0]);
        this.postConfig();
    }

    public SimpleTextDataSource(File file, OutputFactory<T> outputFactory, TextFeatureExtractor<T> extractor) throws IOException {
        super(file, outputFactory, extractor, new DocumentPreprocessor[0]);
        this.postConfig();
    }

    protected SimpleTextDataSource(OutputFactory<T> outputFactory, TextFeatureExtractor<T> extractor) {
        super((Path)null, outputFactory, extractor, new DocumentPreprocessor[0]);
    }

    public void postConfig() throws IOException {
        this.read();
        this.provenance = this.cacheProvenance();
    }

    protected Optional<Example<T>> parseLine(String line, int n) {
        if ((line = line.trim()).isEmpty()) {
            return Optional.empty();
        }
        String[] fields = splitPattern.split(line);
        if (fields.length != 2) {
            logger.warning(String.format("Bad line in %s at %d: %s", this.path, n, line.substring(Math.min(50, line.length()))));
            return Optional.empty();
        }
        String document = fields[1];
        for (DocumentPreprocessor preproc : this.preprocessors) {
            document = preproc.processDoc(document);
            if (document != null) continue;
            return Optional.empty();
        }
        Output label = this.outputFactory.generateOutput((Object)fields[0].trim().toUpperCase());
        return Optional.of(this.extractor.extract(label, this.handleDoc(fields[1].trim())));
    }

    @Override
    protected void read() throws IOException {
        int n = 0;
        for (String line : Files.readAllLines(this.path, StandardCharsets.UTF_8)) {
            Optional<Example<T>> example = this.parseLine(line, ++n);
            if (!example.isPresent()) continue;
            Example<T> e = example.get();
            if (e.validateExample()) {
                this.data.add(e);
                continue;
            }
            logger.warning("Invalid example found after parsing line " + n);
        }
    }

    public ConfiguredDataSourceProvenance getProvenance() {
        return this.provenance;
    }

    protected ConfiguredDataSourceProvenance cacheProvenance() {
        return new SimpleTextDataSourceProvenance(this);
    }

    public static class SimpleTextDataSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements ConfiguredDataSourceProvenance {
        private static final long serialVersionUID = 1L;
        private final DateTimeProvenance fileModifiedTime;
        private final DateTimeProvenance dataSourceCreationTime;
        private final HashProvenance sha256Hash;

        <T extends Output<T>> SimpleTextDataSourceProvenance(SimpleTextDataSource<T> host) {
            super(host, "DataSource");
            this.fileModifiedTime = new DateTimeProvenance("file-modified-time", OffsetDateTime.ofInstant(Instant.ofEpochMilli(((SimpleTextDataSource)host).path.toFile().lastModified()), ZoneId.systemDefault()));
            this.dataSourceCreationTime = new DateTimeProvenance("datasource-creation-time", OffsetDateTime.now());
            this.sha256Hash = new HashProvenance(DEFAULT_HASH_TYPE, "resource-hash", ProvenanceUtil.hashResource((ProvenanceUtil.HashType)DEFAULT_HASH_TYPE, (Path)((SimpleTextDataSource)host).path));
        }

        public SimpleTextDataSourceProvenance(Map<String, Provenance> map) {
            this(SimpleTextDataSourceProvenance.extractProvenanceInfo(map));
        }

        private SimpleTextDataSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
            this.fileModifiedTime = (DateTimeProvenance)info.instanceValues.get("file-modified-time");
            this.dataSourceCreationTime = (DateTimeProvenance)info.instanceValues.get("datasource-creation-time");
            this.sha256Hash = (HashProvenance)info.instanceValues.get("resource-hash");
        }

        protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)SimpleTextDataSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)SimpleTextDataSourceProvenance.class.getSimpleName())).getValue();
            HashMap<String, Provenance> instanceParameters = new HashMap<String, Provenance>();
            instanceParameters.put("file-modified-time", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"file-modified-time", DateTimeProvenance.class, (String)SimpleTextDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("datasource-creation-time", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"datasource-creation-time", DateTimeProvenance.class, (String)SimpleTextDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("resource-hash", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"resource-hash", HashProvenance.class, (String)SimpleTextDataSourceProvenance.class.getSimpleName()));
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, instanceParameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleTextDataSourceProvenance)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SimpleTextDataSourceProvenance pairs = (SimpleTextDataSourceProvenance)((Object)o);
            return this.fileModifiedTime.equals((Object)pairs.fileModifiedTime) && this.dataSourceCreationTime.equals((Object)pairs.dataSourceCreationTime) && this.sha256Hash.equals((Object)pairs.sha256Hash);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fileModifiedTime, this.dataSourceCreationTime, this.sha256Hash);
        }

        public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
            HashMap map = new HashMap();
            map.put("file-modified-time", (PrimitiveProvenance<?>)this.fileModifiedTime);
            map.put("datasource-creation-time", (PrimitiveProvenance<?>)this.dataSourceCreationTime);
            map.put("resource-hash", (PrimitiveProvenance<?>)this.sha256Hash);
            return map;
        }
    }
}

