/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.mutable.MutableRelVisitor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Util;

abstract class MutableMultiRel
extends MutableRel {
    protected final List<MutableRel> inputs;

    protected MutableMultiRel(RelOptCluster cluster, RelDataType rowType, MutableRelType type2, List<MutableRel> inputs) {
        super(cluster, rowType, type2);
        this.inputs = new ArrayList<MutableRel>(inputs);
        for (Ord<MutableRel> input : Ord.zip(inputs)) {
            ((MutableRel)input.e).parent = this;
            ((MutableRel)input.e).ordinalInParent = input.i;
        }
    }

    @Override
    public void setInput(int ordinalInParent, MutableRel input) {
        this.inputs.set(ordinalInParent, input);
        if (input != null) {
            input.parent = this;
            input.ordinalInParent = ordinalInParent;
        }
    }

    @Override
    public List<MutableRel> getInputs() {
        return this.inputs;
    }

    @Override
    public void childrenAccept(MutableRelVisitor visitor2) {
        for (MutableRel input : this.inputs) {
            visitor2.visit(input);
        }
    }

    protected List<MutableRel> cloneChildren() {
        return Util.transform(this.inputs, MutableRel::clone);
    }
}

