/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HttpUtils {
    private HttpUtils() {
    }

    public static HttpURLConnection getURLConnection(String url) throws IOException {
        return (HttpURLConnection)URI.create(url).toURL().openConnection();
    }

    public static void appendURLEncodedArgs(StringBuilder out, Map<String, String> args2) {
        int i = 0;
        try {
            for (Map.Entry<String, String> me : args2.entrySet()) {
                if (i++ != 0) {
                    out.append("&");
                }
                out.append(URLEncoder.encode(me.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(me.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void appendURLEncodedArgs(StringBuilder out, CharSequence ... args2) {
        if (args2.length % 2 != 0) {
            throw new IllegalArgumentException("args should contain an even number of items");
        }
        try {
            int appended = 0;
            for (int i = 0; i < args2.length; i += 2) {
                if (args2[i + 1] == null) continue;
                if (appended++ > 0) {
                    out.append("&");
                }
                out.append(URLEncoder.encode(args2[i].toString(), "UTF-8")).append("=").append(URLEncoder.encode(args2[i + 1].toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static InputStream post(String url, CharSequence data2, Map<String, String> headers) throws IOException {
        return HttpUtils.post(url, data2, headers, 10000, 60000);
    }

    public static InputStream post(String url, @Nullable CharSequence data2, Map<String, String> headers, int cTimeout, int rTimeout) throws IOException {
        return HttpUtils.executeMethod(data2 == null ? "GET" : "POST", url, data2, headers, cTimeout, rTimeout);
    }

    public static InputStream executeMethod(String method, String url, @Nullable CharSequence data2, @Nullable Map<String, String> headers, int cTimeout, int rTimeout) throws IOException {
        HttpURLConnection conn = HttpUtils.getURLConnection(url);
        conn.setRequestMethod(method);
        conn.setReadTimeout(rTimeout);
        conn.setConnectTimeout(cTimeout);
        if (headers != null) {
            for (Map.Entry<String, String> me : headers.entrySet()) {
                conn.setRequestProperty(me.getKey(), me.getValue());
            }
        }
        if (data2 == null) {
            return conn.getInputStream();
        }
        conn.setDoOutput(true);
        try (OutputStreamWriter w = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
            w.write(data2.toString());
            ((Writer)w).flush();
            InputStream inputStream2 = conn.getInputStream();
            return inputStream2;
        }
    }
}

