/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlBinaryOperator
extends SqlOperator {
    public SqlBinaryOperator(String name, SqlKind kind, int prec, boolean leftAssoc, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, SqlBinaryOperator.leftPrec(prec, leftAssoc), SqlBinaryOperator.rightPrec(prec, leftAssoc), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.BINARY;
    }

    @Override
    public @Nullable String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{1} {0} {2}";
    }

    @Override
    boolean needsSpace() {
        return !this.getName().equals(".");
    }

    @Override
    public @Nullable SqlOperator reverse() {
        switch (this.kind) {
            case EQUALS: 
            case NOT_EQUALS: 
            case IS_DISTINCT_FROM: 
            case IS_NOT_DISTINCT_FROM: 
            case OR: 
            case AND: 
            case PLUS: 
            case TIMES: {
                return this;
            }
            case GREATER_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
        }
        return null;
    }

    @Override
    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type2) {
        return this.convertType(validator, call, type2);
    }

    private RelDataType convertType(SqlValidator validator, SqlCall call, RelDataType type2) {
        RelDataType operandType0 = validator.getValidatedNodeType((SqlNode)call.operand(0));
        RelDataType operandType1 = validator.getValidatedNodeType((SqlNode)call.operand(1));
        if (SqlTypeUtil.inCharFamily(operandType0) && SqlTypeUtil.inCharFamily(operandType1)) {
            Charset cs0 = operandType0.getCharset();
            Charset cs1 = operandType1.getCharset();
            assert (null != cs0 && null != cs1) : "An implicit or explicit charset should have been set";
            if (!cs0.equals(cs1)) {
                throw validator.newValidationError(call, Static.RESOURCE.incompatibleCharset(this.getName(), cs0.name(), cs1.name()));
            }
            SqlCollation collation0 = operandType0.getCollation();
            SqlCollation collation1 = operandType1.getCollation();
            assert (null != collation0 && null != collation1) : "An implicit or explicit collation should have been set";
            SqlCollation resultCol = SqlCollation.getCoercibilityDyadicOperator(collation0, collation1);
            if (SqlTypeUtil.inCharFamily(type2)) {
                type2 = validator.getTypeFactory().createTypeWithCharsetAndCollation(type2, type2.getCharset(), Objects.requireNonNull(resultCol, "resultCol"));
            }
        }
        return type2;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope2, SqlCall call) {
        RelDataType type2 = super.deriveType(validator, scope2, call);
        return this.convertType(validator, call, type2);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        if (this.getName().equals("/")) {
            if (call.isOperandNull(0, true) || call.isOperandNull(1, true)) {
                return SqlMonotonicity.CONSTANT;
            }
            SqlMonotonicity mono0 = call.getOperandMonotonicity(0);
            SqlMonotonicity mono1 = call.getOperandMonotonicity(1);
            if (mono1 == SqlMonotonicity.CONSTANT && call.isOperandLiteral(1, false)) {
                BigDecimal value = call.getOperandLiteralValue(1, BigDecimal.class);
                if (value == null) {
                    return SqlMonotonicity.CONSTANT;
                }
                switch (value.signum()) {
                    case -1: {
                        return mono0.reverse().unstrict();
                    }
                    case 0: {
                        return SqlMonotonicity.CONSTANT;
                    }
                }
                return mono0.unstrict();
            }
        }
        return super.getMonotonicity(call);
    }

    @Override
    public boolean validRexOperands(int count, Litmus litmus) {
        if (count != 2) {
            if ((this == SqlStdOperatorTable.AND || this == SqlStdOperatorTable.OR) && count > 2) {
                return true;
            }
            return litmus.fail("wrong operand count {} for {}", count, this);
        }
        return litmus.succeed();
    }
}

