/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql;

import java.time.temporal.ChronoUnit;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.DateCalendarEnum;
import shaded.com.google.common.collect.ImmutableSet;

public enum ChronoUnitEnum {
    ERAS(ChronoUnit.ERAS, DateCalendarEnum.NONE, new ChronoUnitEnum[0]),
    CENTURIES(ChronoUnit.CENTURIES, ImmutableSet.of(DateCalendarEnum.ISO_8601, DateCalendarEnum.GREGORIAN), ERAS),
    YEARS_ISO_8601(ChronoUnit.YEARS, DateCalendarEnum.ISO_8601, CENTURIES),
    YEARS_IN_MILLENIA_ISO_8601(ChronoUnit.YEARS, DateCalendarEnum.ISO_8601, CENTURIES),
    YEARS_IN_CENTURY_ISO_8601(ChronoUnit.YEARS, DateCalendarEnum.ISO_8601, CENTURIES),
    DAYS_IN_YEAR_ISO_8601(ChronoUnit.DAYS, DateCalendarEnum.ISO_8601, YEARS_ISO_8601),
    WEEKS_IN_YEAR_ISO_8601(ChronoUnit.WEEKS, DateCalendarEnum.ISO_8601, YEARS_ISO_8601),
    DAYS_JULIAN(ChronoUnit.DAYS, DateCalendarEnum.JULIAN, new ChronoUnitEnum[0]),
    YEARS(ChronoUnit.YEARS, DateCalendarEnum.GREGORIAN, CENTURIES),
    YEARS_IN_MILLENIA(ChronoUnit.YEARS, DateCalendarEnum.GREGORIAN, CENTURIES),
    YEARS_IN_CENTURY(ChronoUnit.YEARS, DateCalendarEnum.GREGORIAN, CENTURIES),
    MONTHS_IN_YEAR(ChronoUnit.MONTHS, DateCalendarEnum.GREGORIAN, YEARS, YEARS_IN_CENTURY),
    DAYS_IN_YEAR(ChronoUnit.DAYS, DateCalendarEnum.GREGORIAN, YEARS, YEARS_IN_CENTURY),
    DAYS_IN_MONTH(ChronoUnit.DAYS, DateCalendarEnum.GREGORIAN, MONTHS_IN_YEAR),
    WEEKS_IN_YEAR(ChronoUnit.WEEKS, DateCalendarEnum.GREGORIAN, YEARS, YEARS_IN_CENTURY),
    WEEKS_IN_MONTH(ChronoUnit.WEEKS, DateCalendarEnum.GREGORIAN, MONTHS_IN_YEAR),
    DAYS_IN_WEEK(ChronoUnit.DAYS, DateCalendarEnum.NONE, YEARS_ISO_8601, WEEKS_IN_MONTH, WEEKS_IN_YEAR),
    HOURS_IN_DAY(ChronoUnit.HOURS, DateCalendarEnum.NONE, DAYS_IN_YEAR, DAYS_IN_MONTH, DAYS_IN_WEEK),
    HALF_DAYS(ChronoUnit.HALF_DAYS, DateCalendarEnum.NONE, DAYS_IN_YEAR, DAYS_IN_MONTH, DAYS_IN_WEEK),
    HOURS_IN_HALF_DAY(ChronoUnit.HOURS, DateCalendarEnum.NONE, HALF_DAYS),
    MINUTES_IN_HOUR(ChronoUnit.MINUTES, DateCalendarEnum.NONE, HOURS_IN_DAY, HOURS_IN_HALF_DAY),
    SECONDS_IN_DAY(ChronoUnit.SECONDS, DateCalendarEnum.NONE, DAYS_IN_YEAR, DAYS_IN_MONTH, DAYS_IN_WEEK),
    SECONDS_IN_MINUTE(ChronoUnit.SECONDS, DateCalendarEnum.NONE, MINUTES_IN_HOUR),
    MILLIS(ChronoUnit.MILLIS, DateCalendarEnum.NONE, SECONDS_IN_DAY, SECONDS_IN_MINUTE),
    MICROS(ChronoUnit.MICROS, DateCalendarEnum.NONE, MILLIS),
    TENTHS_OF_SECOND(ChronoUnit.MILLIS, DateCalendarEnum.NONE, SECONDS_IN_DAY, SECONDS_IN_MINUTE),
    HUNDREDTHS_OF_SECOND(ChronoUnit.MILLIS, DateCalendarEnum.NONE, SECONDS_IN_DAY, SECONDS_IN_MINUTE),
    THOUSANDTHS_OF_SECOND(ChronoUnit.MILLIS, DateCalendarEnum.NONE, SECONDS_IN_DAY, SECONDS_IN_MINUTE),
    TENTHS_OF_MS(ChronoUnit.MICROS, DateCalendarEnum.NONE, SECONDS_IN_DAY, SECONDS_IN_MINUTE),
    HUNDREDTHS_OF_MS(ChronoUnit.MICROS, DateCalendarEnum.NONE, SECONDS_IN_DAY, SECONDS_IN_MINUTE),
    THOUSANDTHS_OF_MS(ChronoUnit.MICROS, DateCalendarEnum.NONE, SECONDS_IN_DAY, SECONDS_IN_MINUTE),
    TIMEZONE_HOURS(ChronoUnit.HOURS, DateCalendarEnum.NONE, new ChronoUnitEnum[0]),
    TIMEZONE_MINUTES(ChronoUnit.MINUTES, DateCalendarEnum.NONE, TIMEZONE_HOURS);

    private final ChronoUnit chronoUnit;
    private final ImmutableSet<ChronoUnitEnum> parentUnits;
    private final ImmutableSet<DateCalendarEnum> calendars;

    private ChronoUnitEnum(ChronoUnit chronoUnit, DateCalendarEnum calendar, ChronoUnitEnum ... parentUnits) {
        this.chronoUnit = chronoUnit;
        this.parentUnits = ImmutableSet.copyOf(parentUnits);
        this.calendars = ImmutableSet.of(calendar);
    }

    private ChronoUnitEnum(ChronoUnit chronoUnit, Set<DateCalendarEnum> calendars, ChronoUnitEnum ... parentUnits) {
        this.chronoUnit = chronoUnit;
        this.parentUnits = ImmutableSet.copyOf(parentUnits);
        this.calendars = ((ImmutableSet.Builder)ImmutableSet.builder().addAll(calendars)).build();
    }

    public ChronoUnit getChronoUnit() {
        return this.chronoUnit;
    }

    public Set<DateCalendarEnum> getCalendars() {
        return this.calendars;
    }

    public boolean isCompatible(Set<ChronoUnitEnum> units) {
        if (!this.calendars.isEmpty()) {
            for (ChronoUnitEnum unit : units) {
                boolean haveCompatibleCalendar = false;
                for (DateCalendarEnum unitCalendar : unit.getCalendars()) {
                    for (DateCalendarEnum calendar : this.calendars) {
                        if (unitCalendar != DateCalendarEnum.NONE && calendar != DateCalendarEnum.NONE && !unitCalendar.isCalendarCompatible(calendar)) continue;
                        haveCompatibleCalendar = true;
                        break;
                    }
                    if (!haveCompatibleCalendar) continue;
                    break;
                }
                if (haveCompatibleCalendar) continue;
                return false;
            }
        }
        for (ChronoUnitEnum unit : units) {
            if (!this.parentUnits.equals(unit.parentUnits)) continue;
            return false;
        }
        return true;
    }
}

