/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.NumberUtil;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;

public abstract class AbstractCalciteIndexScan
extends TableScan {
    public final OpenSearchIndex osIndex;
    protected final RelDataType schema;
    protected final PushDownContext pushDownContext;

    protected AbstractCalciteIndexScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, PushDownContext pushDownContext) {
        super(cluster, traitSet, hints, table);
        this.osIndex = Objects.requireNonNull(osIndex, "OpenSearch index");
        this.schema = schema;
        this.pushDownContext = pushDownContext;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.schema;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        OpenSearchRequestBuilder requestBuilder = this.osIndex.createRequestBuilder();
        this.pushDownContext.forEach(action -> action.apply(requestBuilder));
        String explainString = String.valueOf(this.pushDownContext) + ", " + String.valueOf(requestBuilder);
        return super.explainTerms(pw).itemIf("PushDownContext", explainString, !this.pushDownContext.isEmpty());
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double estimateRowCountFactor = (Double)this.osIndex.getSettings().getSettingValue(Settings.Key.CALCITE_PUSHDOWN_ROWCOUNT_ESTIMATION_FACTOR);
        return this.pushDownContext.stream().reduce(this.osIndex.getMaxResultWindow().doubleValue(), (rowCount, action) -> (switch (action.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> mq.getRowCount((RelNode)action.digest);
            case 1 -> rowCount;
            case 0 -> NumberUtil.multiply(rowCount, RelMdUtil.guessSelectivity((RexNode)action.digest));
            case 3 -> ((Integer)action.digest).intValue();
        }) * estimateRowCountFactor, (a, b) -> null);
    }

    @Generated
    public OpenSearchIndex getOsIndex() {
        return this.osIndex;
    }

    @Generated
    public RelDataType getSchema() {
        return this.schema;
    }

    @Generated
    public PushDownContext getPushDownContext() {
        return this.pushDownContext;
    }

    public static class PushDownContext
    extends ArrayDeque<PushDownAction> {
        private boolean isAggregatePushed = false;
        private boolean isLimitPushed = false;

        @Override
        public PushDownContext clone() {
            return (PushDownContext)super.clone();
        }

        @Override
        public boolean add(PushDownAction pushDownAction) {
            assert (!this.isAggregatePushed) : "Aggregate has already been pushed!";
            if (pushDownAction.type == PushDownType.AGGREGATION) {
                this.isAggregatePushed = true;
            }
            if (pushDownAction.type == PushDownType.LIMIT) {
                this.isLimitPushed = true;
            }
            return super.add(pushDownAction);
        }

        public boolean isAggregatePushed() {
            if (this.isAggregatePushed) {
                return true;
            }
            this.isAggregatePushed = !this.isEmpty() && ((PushDownAction)super.peekLast()).type == PushDownType.AGGREGATION;
            return this.isAggregatePushed;
        }

        public boolean isLimitPushed() {
            return this.isLimitPushed;
        }
    }

    public record PushDownAction(PushDownType type, Object digest, AbstractAction action) {
        static PushDownAction of(PushDownType type2, Object digest, AbstractAction action) {
            return new PushDownAction(type2, digest, action);
        }

        @Override
        public String toString() {
            return String.valueOf((Object)this.type) + "->" + String.valueOf(this.digest);
        }

        public void apply(OpenSearchRequestBuilder requestBuilder) {
            this.action.apply(requestBuilder);
        }
    }

    protected static enum PushDownType {
        FILTER,
        PROJECT,
        AGGREGATION,
        LIMIT;

    }

    public static interface AbstractAction {
        public void apply(OpenSearchRequestBuilder var1);
    }
}

