/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.NamedArgumentExpression;

public final class TableFunctionUtils {
    public static void validatePrometheusTableFunctionArguments(List<Expression> arguments2, List<String> argumentNames) {
        Boolean argumentsPassedByName = arguments2.stream().noneMatch(arg -> StringUtils.isEmpty(((NamedArgumentExpression)arg).getArgName()));
        Boolean argumentsPassedByPosition = arguments2.stream().allMatch(arg -> StringUtils.isEmpty(((NamedArgumentExpression)arg).getArgName()));
        if (!argumentsPassedByName.booleanValue() && !argumentsPassedByPosition.booleanValue()) {
            throw new SemanticCheckException("Arguments should be either passed by name or position");
        }
        if (arguments2.size() != argumentNames.size()) {
            throw new SemanticCheckException(TableFunctionUtils.generateErrorMessageForMissingArguments(argumentsPassedByPosition, arguments2, argumentNames));
        }
    }

    public static List<Expression> getNamedArgumentsOfTableFunction(List<Expression> arguments2, List<String> argumentNames) {
        boolean argumentsPassedByPosition = arguments2.stream().allMatch(arg -> StringUtils.isEmpty(((NamedArgumentExpression)arg).getArgName()));
        if (argumentsPassedByPosition) {
            ArrayList<Expression> namedArguments = new ArrayList<Expression>();
            for (int i = 0; i < arguments2.size(); ++i) {
                namedArguments.add(new NamedArgumentExpression(argumentNames.get(i), ((NamedArgumentExpression)arguments2.get(i)).getValue()));
            }
            return namedArguments;
        }
        return arguments2;
    }

    private static String generateErrorMessageForMissingArguments(Boolean areArgumentsPassedByPosition, List<Expression> arguments2, List<String> argumentNames) {
        if (areArgumentsPassedByPosition.booleanValue()) {
            return String.format("Missing arguments:[%s]", String.join((CharSequence)",", argumentNames.subList(arguments2.size(), argumentNames.size())));
        }
        HashSet<String> requiredArguments = new HashSet<String>(argumentNames);
        Set providedArguments = arguments2.stream().map(expression -> ((NamedArgumentExpression)expression).getArgName()).collect(Collectors.toSet());
        requiredArguments.removeAll(providedArguments);
        return String.format("Missing arguments:[%s]", String.join((CharSequence)",", requiredArguments));
    }

    @Generated
    private TableFunctionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

